% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\name{ranks}
\alias{ranks}
\title{Rank values in an Object}
\usage{
ranks(object)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}.}
}
\value{
Either \code{NULL} or vector.
}
\description{
Retrieve or set the rank values in an object
}
\details{
Ranks for which factorization has been performed are stored 
in slot \code{ranks} of \code{scNMFSet} object.
\code{ranks(object)} will return the rank vector. 
\code{ranks(object) <- value}
can be used to modify it.
}
\examples{
s <- scNMFSet(matrix(rpois(n=12,lambda=3),4,3))
s <- vb_factorize(s,ranks=seq(2,4))
ranks(s)
}
