% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{build_tree}
\alias{build_tree}
\title{Build tree connecting clusters at different ranks}
\usage{
build_tree(object, rmax)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}}

\item{rmax}{Maximum rank at which tree branching stops}
}
\value{
List containing the tree structure
}
\description{
Build tree connecting clusters at different ranks
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
tree <- build_tree(s,rmax=5)
tree
}
