% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-heatmapOutput.R
\name{heatmapOutput}
\alias{heatmapOutput}
\title{Generate heatmaps for various studies/subgroups of a study.}
\usage{
heatmapOutput(submissionName, shortenStudyNames = TRUE,
  geneLimit = 50, rankingMethod = "variation", heatmapFileFormat = "TIFF",
  resolution = 600, RowCex = "auto", ColCex = "auto",
  heatmapMargines = "auto", rowLabelsAngle = 0, columnLabelsAngle = 45,
  heatmapColor = "RdBu", reverseColor = TRUE, transposedHeatmap = FALSE,
  simplifyBy = FALSE, genesToDrop = FALSE)
}
\arguments{
\item{submissionName}{a character string containing name of interest. It is
used for naming the process.}

\item{shortenStudyNames}{a logical vector. If the value is set as TRUE,
function will try to remove the last part of the cancer names aiming to
shorten them. The removed segment usually contains the name of scientific
group that has conducted the experiment.}

\item{geneLimit}{if large number of genes exist in at least one gene group,
this option can be used to limit the number of genes that are shown on
heatmap. For instance, \code{geneLimit=50} will limit the heatmap to 50 genes
that show the most variation across multiple study / study subgroups. The
default value is \code{50}.}

\item{rankingMethod}{a character value that determines how genes will be
ranked prior to drawing heatmap. \code{"variation"} orders the genes based on
unique values in one or few cancer studies while \code{"highValue"} ranks the
 genes when they contain high values in multiple / many cancer studies. This
 option is useful when number of genes are too much so that user has to limit
 the number of genes on heatmap by \code{geneLimit}.}

\item{heatmapFileFormat}{This option enables the user to select the desired
image file format of the heatmaps. The default value is \code{"TIFF"}. Other
supported formats include \code{"JPG"}, \code{"BMP"}, \code{"PNG"}, and
\code{"PDF"}.}

\item{resolution}{a number. This option can be used to adjust the resolution
of the output heatmaps as 'dot per inch'. The defalut value is 600.}

\item{RowCex}{a number that specifies letter size in heatmap row names,
which ranges from 0 to 2. If \code{RowCex = "auto"}, the function will
automatically determine the best RowCex.}

\item{ColCex}{a number that specifies letter size in heatmap column names,
which ranges from 0 to 2. If \code{ColCex = "auto"}, the function will
automatically determine the best ColCex.}

\item{heatmapMargines}{a numeric vector that is used to set heatmap margins.
If \code{heatmapMargines = "auto"}, the function will automatically
determine the best possible margines. Otherwise, enter the desired margine as
e.g. c(10,10.)}

\item{rowLabelsAngle}{a number that determines the angle with which the
gene names are shown in heatmaps. The default value is 0 degree.}

\item{columnLabelsAngle}{a number that determines the angle with which the
studies/study subgroups names are shown in heatmaps. The default value is 45
degree.}

\item{heatmapColor}{a character string that defines heatmap color. The
default value is \code{'RdBu'}. \code{'RdGr'} is also a popular color in
genomic studies. To see the rest of colors, please type
\code{library(RColorBrewer)} and then \code{display.brewer.all()}.}

\item{reverseColor}{a logical value that reverses the color gradiant for
heatmap(s).}

\item{transposedHeatmap}{a logical value that transposes heatmap rows to
columns and vice versa.}

\item{simplifyBy}{a number that tells the function to change the values
smaller than that to zero. The purpose behind this option is to facilitate
recognizing candidate genes. Therefore, it is not suited for publications. It
has the same unit as \code{cutoff}.}

\item{genesToDrop}{a character vector. Gene names within this vector will be
omitted from heatmap.The default value is \code{FALSE}.}
}
\value{
Based on preference, three heatmaps for \code{"Frequency.Percentage"}
, \code{"Mean.Value"} and \code{"Median.value"} can be generated. If more
than one group of genes are entered, output for each group will be strored in
 a separate sub-directory.
}
\description{
This function can prepare heatmap for 'frequency percentage',
'mean value' and 'median value' data provided by
automatedStatistics() function.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\examples{
genes <- list(K.demethylases = c("KDM1A", "KDM1B", "KDM2A", "KDM2B", "KDM3A",
 "KDM3B", "JMJD1C", "KDM4A"), K.methyltransferases = c("SUV39H1", "SUV39H2",
 "EHMT1", "EHMT2", "SETDB1", "SETDB2", "KMT2A", "KMT2A"))

obtainOneStudy(genes, "test", "Breast Invasive Carcinoma (TCGA, Cell 2015)",
"RNA-Seq", desiredCaseList = c(3,4))

automatedStatistics("test", obtainedDataType = "single study", calculate =
c("frequencyPercentage", "frequencyRatio"))

heatmapOutput(submissionName = "test")



}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
