% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_mining.R
\name{mine_step3}
\alias{mine_step3}
\title{Step 3: Select candidates based on gene significance}
\usage{
mine_step3(
  exp,
  metadata,
  metadata_cols = 1,
  candidates,
  sample_group,
  min_cor = 0.2,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{exp}{Expression data frame with genes in row names and samples in
column names or a SummarizedExperiment object.}

\item{metadata}{Sample metadata with samples in row names and sample
information in the first column. Ignored if \code{exp} is a SummarizedExperiment
object, as the colData will be extracted from the object.}

\item{metadata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from column metadata if \strong{exp}
is a \code{SummarizedExperiment} object. The vector can contain column indices
(numeric) or column names (character). By default, all columns are used.}

\item{candidates}{Character vector of candidate genes to be inspected.}

\item{sample_group}{Level of sample metadata to be used for filtering
in gene-trait correlation.}

\item{min_cor}{Minimum correlation value for
\code{BioNERO::gene_significance()}. Default: 0.2}

\item{alpha}{Numeric indicating significance level. Default: 0.05}

\item{...}{Additional arguments to \code{BioNERO::gene_significance}.}
}
\value{
A data frame with mined candidate genes and their correlation to
the condition of interest.
}
\description{
Step 3: Select candidates based on gene significance
}
\examples{
data(pepper_se)
data(snp_pos)
data(gene_ranges)
data(guides)
data(gcn)
data(mine2)
set.seed(1)
mine3 <- mine_step3(
    exp = pepper_se,
    candidates = mine2$candidates,
    sample_group = "PRR_stress"
)
}
