% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_mining.R
\name{mine_step2}
\alias{mine_step2}
\title{Step 2: Get candidates in modules enriched in guide genes}
\usage{
mine_step2(exp, gcn, guides, candidates, ...)
}
\arguments{
\item{exp}{Expression data frame with genes in row names and samples in
column names or a SummarizedExperiment object.}

\item{gcn}{Gene coexpression network returned by \code{BioNERO::exp2gcn()}.}

\item{guides}{Guide genes as a character vector or as a data frame with
genes in the first column and gene annotation class in the second column.}

\item{candidates}{Character vector of all candidates genes to be inspected.}

\item{...}{Additional arguments to \code{BioNERO::module_enrichment}}
}
\value{
A list of 2 elements:
\describe{
\item{candidates}{Character vector of candidates after step 2}
\item{enrichment}{Data frame of results for enrichment analysis}
}
}
\description{
Step 2: Get candidates in modules enriched in guide genes
}
\examples{
data(pepper_se)
data(guides)
data(gcn)
set.seed(1)
mine2 <- mine_step2(
    exp = pepper_se,
    gcn = gcn,
    guides = guides$Gene,
    candidates = rownames(pepper_se)
)
}
