% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{loadCMapData}
\alias{loadCMapData}
\title{Load CMap data}
\usage{
loadCMapData(
  file,
  type = c("metadata", "geneInfo", "zscores", "compoundInfo"),
  zscoresID = NULL
)
}
\arguments{
\item{file}{Character: path to file}

\item{type}{Character: type of data to load (\code{metadata},
\code{geneInfo}, \code{zscores} or \code{compoundInfo})}

\item{zscoresID}{Character: identifiers to partially load z-scores file
(for performance reasons; if \code{NULL}, all identifiers will be loaded)}
}
\value{
Metadata as a data table
}
\description{
Load CMap data (if not found, \code{file} will be automatically downloaded)
}
\note{
If \code{type = "compoundInfo"}, two files from
\strong{The Drug Repurposing Hub} will be downloaded containing information
about drugs and perturbations. The files will be named \code{file} with
\code{_drugs} and \code{_samples} before their extension, respectively.
}
\examples{
# Load CMap metadata (data is automatically downloaded if not available)
cmapMetadata <- loadCMapData("cmapMetadata.txt", "metadata")

# Load CMap gene info
loadCMapData("cmapGeneInfo.txt", "geneInfo")
\dontrun{
# Load CMap zscores based on filtered metadata
cmapMetadataKnockdown <- filterCMapMetadata(
  cmapMetadata, cellLine="HepG2",
  perturbationType="Consensus signature from shRNAs targeting the same gene")
loadCMapData("cmapZscores.gctx.gz", "zscores", cmapMetadataKnockdown$sig_id)
}
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
