% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTRAP-package.r
\docType{data}
\name{counts}
\alias{counts}
\title{Gene expression data sample}
\description{
Gene expression data sample obtained by running the following code:

\preformatted{
data("ENCODEmetadata")
ENCODEsamples <- loadENCODEsamples(ENCODEmetadata)[[1]]
counts <- prepareENCODEgeneExpression(ENCODEsamples)

# Remove low coverage (at least 10 counts shared across two samples)
minReads   <- 10
minSamples <- 2
filter <- rowSums(counts[ , -c(1, 2)] >= minReads) >= minSamples
counts <- counts[filter, ]

# Convert ENSEMBL identifier to gene symbol
counts$gene_id <- convertGeneIdentifiers(counts$gene_id)
}
}
\keyword{internal}
