% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBioDataPack.R
\name{cBioDataPack}
\alias{cBioDataPack}
\title{Obtain pre-packaged data from cBioPortal and represent as
a MultiAssayExperiment object}
\usage{
cBioDataPack(
  cancer_study_id,
  use_cache = TRUE,
  names.field = c("Hugo_Symbol", "Entrez_Gene_Id", "Gene"),
  cleanup = TRUE,
  ask = interactive(),
  check_build = TRUE
)
}
\arguments{
\item{cancer_study_id}{\code{character(1)} The study identifier from cBioPortal as
seen in the dataset links at \url{https://www.cbioportal.org/datasets}.}

\item{use_cache}{\code{logical(1)} (default TRUE) create the default cache
location and use it to track downloaded data. If data found in the cache,
data will not be re-downloaded. A path can also be provided to data cache
location.}

\item{names.field}{\code{character()} Possible column names for the column that
will used to label ranges for data such as mutations or copy number
(defaults: "Hugo_Symbol", "Entrez_Gene_Id", "Gene", and
"Composite.Element.REF"). Values are cycled through and eliminated when no
data present, or duplicates are found. Values in the corresponding column
must be unique in each row.}

\item{cleanup}{\code{logical(1)} whether to delete the \code{untar}-red contents from
the \code{exdir} folder (default TRUE)}

\item{ask}{\code{logical(1)} Whether to prompt the the user before downloading and
loading study \code{MultiAssayExperiment} that is not currently building based
on previous testing. Set to \code{interactive()} by default. In a
non-interactive session, data download will be attempted; equivalent to
\code{ask = FALSE}. The argument will also be used when a cache directory needs
to be created when using \code{downloadStudy}.}

\item{check_build}{logical(1L) Whether to check the build status of the
\code{studyId} using an internal dataset. This argument should be set to
\code{FALSE} if using alternative \code{hostnames}, e.g.,
'pedcbioportal.kidsfirstdrc.org'}
}
\value{
A
\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}
object
}
\description{
The \code{cBioDataPack} function allows the user to
download and process cancer study datasets found in MSKCC's cBioPortal.
Output datasets use the
\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}
data representation to faciliate analysis and data management operations.
}
\details{
The full list of study identifiers (\code{studyId}s) can obtained from
\code{getStudies()}. Currently, only ~ 72\% of datasets can be represented as
\code{MultiAssayExperiment} data objects from the data tarballs. Refer to
\code{getStudies(..., buildReport = TRUE)} and its \code{"pack_build"} column to see
which study identifiers are not building. Users who would like to prioritize
particular datasets should open GitHub issues at the URL in the
\code{DESCRIPTION} file. For a more fine-grained approach to downloading data
from the cBioPortal API, refer to the \code{cBioPortalData} function.
}
\section{cBio_URL}{

The \code{cBioDataPack} function accesses data from the \code{cBio_URL} option.
By default, it points to an Amazon S3 bucket location. Previously, it
pointed to 'http://download.cbioportal.org'. This recent change
(> 2.1.17) should provide faster and more reliable downloads for all users.
See the URL using \code{cBioPortalData:::.CBIOPORTAL_DATA_URL}. This can be
changed if there are mirrors that host this data by setting the \code{cBio_URL}
option with \code{getOption("cBio_URL", "https://some.url.com/")} before running
the function.
}

\examples{

cbio <- cBioPortal()

head(getStudies(cbio)[["studyId"]])

mae <- cBioDataPack("acc_tcga")

}
\seealso{
\url{https://www.cbioportal.org/datasets}, \link{cBioPortalData},
\link{removePackCache}
}
\author{
Levi Waldron, Marcel R., Ino dB.
}
