% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{find_best_params}
\alias{find_best_params}
\title{Identify the Best Parameters For Your Dataset}
\usage{
find_best_params(
  x,
  genelist,
  bins_count_range = c(5, 10, 20, 40),
  gene_count_range = c(10, 20, 40, 80),
  bootstrap_iterations = 200,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{x}{The object to create `BlaseData`` from}

\item{genelist}{Vector of strings. The list of genes to use
(ordered by descending goodness)}

\item{bins_count_range}{Integer vector. The n_bins list to try out}

\item{gene_count_range}{Integer vector. The n_genes list to try out}

\item{bootstrap_iterations}{Integer. Iterations for bootstrapping
when calculating confident mappings.}

\item{BPPARAM}{The \link[BiocParallel:BiocParallelParam-class]{BiocParallel::BiocParallelParam}. Defaults to
\link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam}}

\item{...}{params to be passed to child functions, see \code{\link[=as.BlaseData]{as.BlaseData()}}}
}
\value{
A dataframe of the results.
\itemize{
\item bin_count: Integer. The bin count for this attempt
\item gene_count: Integer. The top n genes to use for this attempt
\item min_convexity: Decimal. The worst convexity for these parameters
\item mean_convexity: Decimal. The mean convexity for these parameters
\item confident_mapping_pct: Decimal. The percent of bins which were
confidently mapped to themselves for these parameters.
If this value is low, then it is likely that in real use,
few or no results will be confidently mapped.
}
}
\description{
Identify the Best Parameters For Your Dataset
}
\examples{
ncells <- 70
ngenes <- 100
counts_matrix <- matrix(
    c(seq_len(3500) / 10, seq_len(3500) / 5),
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- paste0("cell", seq_len(ncells))
rownames(sce) <- paste0("gene", seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- rownames(sce)

# Finding the best params for the BlaseData
best_params <- find_best_params(
    sce, genelist,
    bins_count_range = c(2, 3),
    gene_count_range = c(20, 50),
    pseudotime_slot = "pseudotime",
    split_by = "pseudotime_range"
)
best_params
plot_find_best_params_results(best_params)
}
\seealso{
\code{\link[=plot_find_best_params_results]{plot_find_best_params_results()}} for plotting the
results of this function.
}
\concept{tuning}
