% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grToSeg.R
\name{grToSeg}
\alias{grToSeg}
\title{Dump GRanges to segmented data data.frame}
\usage{
grToSeg(gr, filename = NULL, minAbs = NULL)
}
\arguments{
\item{gr}{A GRanges or GRangesList to dump to .seg file}

\item{filename}{Where to save the result - unsaved if NULL (DEFAULT: NULL)}

\item{minAbs}{Minimum absolute gain/loss cutoff (DEFAULT: NULL)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     A data.frame with columns:
               (ID, chrom, loc.start, loc.end, num.mark, seg.mean)
}\if{html}{\out{</div>}}
}
\description{
Output data.frame can be written to a .seg file if supplied with filename
input argument
}
\examples{

  clock <- getClock(model="horvathshrunk", genome="hg38")
  gr <- clock$gr

  df <- grToSeg(gr = gr)

}
\seealso{
segToGr
}
