% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbEntryField.R
\name{BiodbEntryField}
\alias{BiodbEntryField}
\title{A class for describing an entry field.}
\description{
A class for describing an entry field.

A class for describing an entry field.
}
\details{
This class is used by \code{\link{BiodbEntryFields}} for storing field
characteristics, and returning them through the \code{get()} method. The
constructor is not meant to be used, but for development purposes the
constructor's parameters are nevertheless described in the Fields section.

The constructor accepts the following arguments:

name: The name of the field.

alias: A character vector containing zero or more aliases for the field.

type: A type describing the field. One of: "mass", "name" or "id". Optional.

class: The class of the field. One of: "character", "integer", "double",
"logical", "object", "data.frame".

card: The cardinality of the field: either "1" or "*".

forbids.duplicates: If set to TRUE, the field forbids duplicated values.

description: A description of the field.

allowed.values: The values authorized for the field.

lower.case: Set to TRUE if you want all values set to the field to be forced
to lower case.

case.insensitive: Set to TRUE of you want the field to ignore case when
checking a value.

computable.from: The Biodb ID of a database, from which this field can be
computed.

virtual: If set to \code{TRUE}, the field is computed from other fields, and
thus cannot be modified.

virtual.group.by.type: For a virtual field of class data.frame, this
indicates to gather all fields of the specified type to build a data frame.
}
\examples{
# Get the class of the InChI field.
mybiodb <- biodb::newInst()
inchi.field.class <- mybiodb$getEntryFields()$get('inchi')$getClass()

# Test the cardinality of a field
card.one <- mybiodb$getEntryFields()$get('name')$hasCardOne()
card.many <- mybiodb$getEntryFields()$get('name')$hasCardMany()

# Get the description of a field
desc <- mybiodb$getEntryFields()$get('inchi')$getDescription()

# Terminate instance.
mybiodb$terminate()

}
\seealso{
Parent class \code{\link{BiodbEntryFields}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbEntryField-new}{\code{BiodbEntryField$new()}}
\item \href{#method-BiodbEntryField-getName}{\code{BiodbEntryField$getName()}}
\item \href{#method-BiodbEntryField-getType}{\code{BiodbEntryField$getType()}}
\item \href{#method-BiodbEntryField-isOfType}{\code{BiodbEntryField$isOfType()}}
\item \href{#method-BiodbEntryField-getDescription}{\code{BiodbEntryField$getDescription()}}
\item \href{#method-BiodbEntryField-hasAliases}{\code{BiodbEntryField$hasAliases()}}
\item \href{#method-BiodbEntryField-getAliases}{\code{BiodbEntryField$getAliases()}}
\item \href{#method-BiodbEntryField-addAlias}{\code{BiodbEntryField$addAlias()}}
\item \href{#method-BiodbEntryField-removeAlias}{\code{BiodbEntryField$removeAlias()}}
\item \href{#method-BiodbEntryField-getAllNames}{\code{BiodbEntryField$getAllNames()}}
\item \href{#method-BiodbEntryField-isComputable}{\code{BiodbEntryField$isComputable()}}
\item \href{#method-BiodbEntryField-getComputableFrom}{\code{BiodbEntryField$getComputableFrom()}}
\item \href{#method-BiodbEntryField-getDataFrameGroup}{\code{BiodbEntryField$getDataFrameGroup()}}
\item \href{#method-BiodbEntryField-isComputableFrom}{\code{BiodbEntryField$isComputableFrom()}}
\item \href{#method-BiodbEntryField-addComputableFrom}{\code{BiodbEntryField$addComputableFrom()}}
\item \href{#method-BiodbEntryField-removeComputableFrom}{\code{BiodbEntryField$removeComputableFrom()}}
\item \href{#method-BiodbEntryField-correctValue}{\code{BiodbEntryField$correctValue()}}
\item \href{#method-BiodbEntryField-isEnumerate}{\code{BiodbEntryField$isEnumerate()}}
\item \href{#method-BiodbEntryField-isVirtual}{\code{BiodbEntryField$isVirtual()}}
\item \href{#method-BiodbEntryField-getVirtualGroupByType}{\code{BiodbEntryField$getVirtualGroupByType()}}
\item \href{#method-BiodbEntryField-getAllowedValues}{\code{BiodbEntryField$getAllowedValues()}}
\item \href{#method-BiodbEntryField-addAllowedValue}{\code{BiodbEntryField$addAllowedValue()}}
\item \href{#method-BiodbEntryField-checkValue}{\code{BiodbEntryField$checkValue()}}
\item \href{#method-BiodbEntryField-hasCardOne}{\code{BiodbEntryField$hasCardOne()}}
\item \href{#method-BiodbEntryField-hasCardMany}{\code{BiodbEntryField$hasCardMany()}}
\item \href{#method-BiodbEntryField-forbidsDuplicates}{\code{BiodbEntryField$forbidsDuplicates()}}
\item \href{#method-BiodbEntryField-isCaseInsensitive}{\code{BiodbEntryField$isCaseInsensitive()}}
\item \href{#method-BiodbEntryField-getClass}{\code{BiodbEntryField$getClass()}}
\item \href{#method-BiodbEntryField-isObject}{\code{BiodbEntryField$isObject()}}
\item \href{#method-BiodbEntryField-isDataFrame}{\code{BiodbEntryField$isDataFrame()}}
\item \href{#method-BiodbEntryField-isAtomic}{\code{BiodbEntryField$isAtomic()}}
\item \href{#method-BiodbEntryField-isVector}{\code{BiodbEntryField$isVector()}}
\item \href{#method-BiodbEntryField-equals}{\code{BiodbEntryField$equals()}}
\item \href{#method-BiodbEntryField-updateWithValuesFrom}{\code{BiodbEntryField$updateWithValuesFrom()}}
\item \href{#method-BiodbEntryField-print}{\code{BiodbEntryField$print()}}
\item \href{#method-BiodbEntryField-getCardinality}{\code{BiodbEntryField$getCardinality()}}
\item \href{#method-BiodbEntryField-check}{\code{BiodbEntryField$check()}}
\item \href{#method-BiodbEntryField-clone}{\code{BiodbEntryField$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. This class must not be instantiated directly.
Instead, you access the instances of this class through the
BiodbEntryFields instance that you get from the BiodbMain instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$new(
  parent,
  name,
  alias = NA_character_,
  type = NA_character_,
  class = c("character", "integer", "double", "logical", "object", "data.frame"),
  card = c("one", "many"),
  forbids.duplicates = FALSE,
  description = NA_character_,
  allowed.values = NULL,
  lower.case = FALSE,
  case.insensitive = FALSE,
  computable.from = NULL,
  virtual = FALSE,
  virtual.group.by.type = NULL,
  dataFrameGroup = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{The BiodbEntryFields parent instance.}

\item{\code{name}}{The field name.}

\item{\code{alias}}{The field aliases as a character vector.}

\item{\code{type}}{The field type.}

\item{\code{class}}{The field class.}

\item{\code{card}}{The field cardinality.}

\item{\code{forbids.duplicates}}{Set to TRUE to forbid duplicated values.}

\item{\code{description}}{The field description.}

\item{\code{allowed.values}}{Restrict possible values to a set of allowed
values.}

\item{\code{lower.case}}{All values will be converted to lower case.}

\item{\code{case.insensitive}}{Comparison will be made case insensitive for
this field.}

\item{\code{computable.from}}{A list of databases from which to compute
automatically the value of this field.}

\item{\code{virtual}}{Set to TRUE if this field is virtual.}

\item{\code{virtual.group.by.type}}{In case of a virtual field, set the type
of fields to group together into a data frame.}

\item{\code{dataFrameGroup}}{The data frame group.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getName}{}}}
\subsection{Method \code{getName()}}{
Gets the name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of this field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getType"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getType}{}}}
\subsection{Method \code{getType()}}{
Gets field's type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The type of this field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isOfType"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isOfType}{}}}
\subsection{Method \code{isOfType()}}{
Tests if this field is of the specified type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isOfType(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if this field is of the specified type, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getDescription"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getDescription}{}}}
\subsection{Method \code{getDescription()}}{
Get field's description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getDescription()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The description of this field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-hasAliases"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-hasAliases}{}}}
\subsection{Method \code{hasAliases()}}{
Tests if this field has aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$hasAliases()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this entry field defines aliases, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getAliases"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getAliases}{}}}
\subsection{Method \code{getAliases()}}{
Get aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getAliases()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of aliases if some are defined, otherwise returns
NULL."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-addAlias"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-addAlias}{}}}
\subsection{Method \code{addAlias()}}{
Adds an alias to the list of aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$addAlias(alias)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alias}}{The name of a valid alias.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-removeAlias"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-removeAlias}{}}}
\subsection{Method \code{removeAlias()}}{
Removes an alias from the list of aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$removeAlias(alias)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alias}}{The name of a valid alias.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getAllNames"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getAllNames}{}}}
\subsection{Method \code{getAllNames()}}{
Gets all names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getAllNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of all names (main name and aliases).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isComputable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isComputable}{}}}
\subsection{Method \code{isComputable()}}{
Tests if this field is computable from another field or another
database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isComputable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the field is computable, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getComputableFrom"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getComputableFrom}{}}}
\subsection{Method \code{getComputableFrom()}}{
Get the list of connectors that can be used to compute this field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getComputableFrom()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of list objects. Each list object contains the name of the
database from which the field is computable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getDataFrameGroup"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getDataFrameGroup}{}}}
\subsection{Method \code{getDataFrameGroup()}}{
Gets the defined data frame group, if any.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getDataFrameGroup()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The data frame group, as a character value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isComputableFrom"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isComputableFrom}{}}}
\subsection{Method \code{isComputableFrom()}}{
Gets the ID of the database from which this field can be computed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isComputableFrom()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of databases where to find this field's value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-addComputableFrom"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-addComputableFrom}{}}}
\subsection{Method \code{addComputableFrom()}}{
Adds a directive from the list of computableFrom.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$addComputableFrom(directive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{directive}}{A valid \"computable from\" directive.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-removeComputableFrom"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-removeComputableFrom}{}}}
\subsection{Method \code{removeComputableFrom()}}{
Removes a directive from the list of computableFrom.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$removeComputableFrom(directive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{directive}}{A valid \"computable from\" directive.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-correctValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-correctValue}{}}}
\subsection{Method \code{correctValue()}}{
Corrects a value so it is compatible with this field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$correctValue(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The corrected value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isEnumerate"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isEnumerate}{}}}
\subsection{Method \code{isEnumerate()}}{
Tests if this field is an enumerate type (i.e.: it defines allowed
values).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isEnumerate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this field defines some allowed values, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isVirtual"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isVirtual}{}}}
\subsection{Method \code{isVirtual()}}{
Tests if this field is a virtual field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isVirtual()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this field is virtual, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getVirtualGroupByType"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getVirtualGroupByType}{}}}
\subsection{Method \code{getVirtualGroupByType()}}{
Gets type for grouping field values when building a virtual data
frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getVirtualGroupByType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The type, as a character value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getAllowedValues"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getAllowedValues}{}}}
\subsection{Method \code{getAllowedValues()}}{
Gets allowed values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getAllowedValues(value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{If this parameter is set to particular allowed values, then the
method returns a list of synonyms for this value (if any).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing all allowed values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-addAllowedValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-addAllowedValue}{}}}
\subsection{Method \code{addAllowedValue()}}{
Adds an allowed value, as a synonym to already an existing value. Note
that not all enumerate fields accept synonyms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$addAllowedValue(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The key associated with the value (i.e.: the key is the
main name of an allowed value).}

\item{\code{value}}{The new value to add.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-checkValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-checkValue}{}}}
\subsection{Method \code{checkValue()}}{
Checks if a value is correct. Fails if \code{value} is incorrect.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$checkValue(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-hasCardOne"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-hasCardOne}{}}}
\subsection{Method \code{hasCardOne()}}{
Tests if this field has a cardinality of one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$hasCardOne()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the cardinality of this field is one, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-hasCardMany"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-hasCardMany}{}}}
\subsection{Method \code{hasCardMany()}}{
Tests if this field has a cardinality greater than one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$hasCardMany()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the cardinality of this field is many, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-forbidsDuplicates"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-forbidsDuplicates}{}}}
\subsection{Method \code{forbidsDuplicates()}}{
Tests if this field forbids duplicates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$forbidsDuplicates()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this field forbids duplicated values, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isCaseInsensitive"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isCaseInsensitive}{}}}
\subsection{Method \code{isCaseInsensitive()}}{
Tests if this field is case sensitive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isCaseInsensitive()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this field is case insensitive, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getClass}{}}}
\subsection{Method \code{getClass()}}{
Gets the class of this field's value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
class) of this field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isObject"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isObject}{}}}
\subsection{Method \code{isObject()}}{
Tests if this field's type is a class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isObject()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if field's type is a class, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isDataFrame}{}}}
\subsection{Method \code{isDataFrame()}}{
Tests if this field's type is \code{data.frame}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isDataFrame()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if field's type is data frame, FALSE otherwise."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isAtomic"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isAtomic}{}}}
\subsection{Method \code{isAtomic()}}{
Tests if this field's type is an atomic  type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isAtomic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character,
integer, double or logical), FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-isVector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-isVector}{}}}
\subsection{Method \code{isVector()}}{
Tests if this field's type is a basic vector type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$isVector()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character,
integer, double or logical), FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-equals"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-equals}{}}}
\subsection{Method \code{equals()}}{
Compares this instance with another, and tests if they are equal.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$equals(other, fail = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{Another BiodbEntryField instance.}

\item{\code{fail}}{If set to TRUE, then throws error instead of returning FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if they are equal, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-updateWithValuesFrom"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-updateWithValuesFrom}{}}}
\subsection{Method \code{updateWithValuesFrom()}}{
Updates fields using values from \code{other} instance. The updated fields
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$updateWithValuesFrom(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{Another BiodbEntryField instance.}

\item{\code{are}}{'alias' and 'computable.from'. No values will be removed
from those vectors. The new values will only be appended. This allows
to extend an existing field inside a new connector definition.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-print}{}}}
\subsection{Method \code{print()}}{
Print informations about this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-getCardinality"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-getCardinality}{}}}
\subsection{Method \code{getCardinality()}}{
Gets the field's cardinality.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$getCardinality()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The cardinality: "one" or "many".
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-check"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-check}{}}}
\subsection{Method \code{check()}}{
Checks if essential values are defined.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$check()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryField-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryField-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryField$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
