% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Progress.R
\name{Progress}
\alias{Progress}
\title{Progress class.}
\description{
A class for informing user about the progress of a process.
}
\details{
This class displays progress of a process to user, and sends
notifications of this progress to observers too.
}
\examples{
# Create an instance
prg <- biodb::Progress$new(msg='Processing data.', total=10L)

# Processing
for (i in seq_len(10)) {
    print("Doing something.")
    prg$increment()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Progress-new}{\code{Progress$new()}}
\item \href{#method-Progress-increment}{\code{Progress$increment()}}
\item \href{#method-Progress-clone}{\code{Progress$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-new"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$new(biodb = NULL, msg, total = NA_integer_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{biodb}}{A BiodbMain instance that will be used to notify observers of
progress.}

\item{\code{msg}}{The message to display to the user.}

\item{\code{total}}{The total number of elements to process or NA if unknown.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-increment"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-increment}{}}}
\subsection{Method \code{increment()}}{
Increment progress.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$increment()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
