% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileTemplate.R
\name{FileTemplate}
\alias{FileTemplate}
\title{File template class.}
\description{
A class for reading a file template, replacing tags inside, and writing the
results in an output file.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileTemplate-new}{\code{FileTemplate$new()}}
\item \href{#method-FileTemplate-replace}{\code{FileTemplate$replace()}}
\item \href{#method-FileTemplate-choose}{\code{FileTemplate$choose()}}
\item \href{#method-FileTemplate-select}{\code{FileTemplate$select()}}
\item \href{#method-FileTemplate-write}{\code{FileTemplate$write()}}
\item \href{#method-FileTemplate-getLines}{\code{FileTemplate$getLines()}}
\item \href{#method-FileTemplate-clone}{\code{FileTemplate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-new"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to the template file.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-replace"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-replace}{}}}
\subsection{Method \code{replace()}}{
Replace a tag by its value inside the template file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$replace(tag, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tag}}{The tag to replace.}

\item{\code{value}}{The value to replace the tag with.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(self) for chaining method calls.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-choose"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-choose}{}}}
\subsection{Method \code{choose()}}{
Choose one case among a set of cases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$choose(set, case)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{The name of the case set.}

\item{\code{case}}{The name of case.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(self) for chaining method calls.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-select"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-select}{}}}
\subsection{Method \code{select()}}{
Select or remove sections that match a name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$select(section, enable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{section}}{The name of the section.}

\item{\code{enable}}{Set to TRUE to select the section (and keep it), and FALSE to
remove it.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(self) for chaining method calls.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-write"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-write}{}}}
\subsection{Method \code{write()}}{
Write template with replaced values to disk.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$write(path, overwrite = FALSE, checkRemainingTags = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to output file.}

\item{\code{overwrite}}{If set to FALSE and the destination file already exists, a
message is thrown. Otherwise writes into the destination.}

\item{\code{checkRemainingTags}}{If set to TRUE, checks first, before writing, if
there any remaining tags that have not been processed. A warning is thrown
for each found tag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-getLines"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-getLines}{}}}
\subsection{Method \code{getLines()}}{
Get the lines of the templates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$getLines()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector containing the lines of the templates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileTemplate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileTemplate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileTemplate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
