% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioc_style.R
\name{bioc_style}
\alias{bioc_style}
\title{Tidyverse style made Bioconductor-friendly}
\usage{
bioc_style(indent_by = 4, ...)
}
\arguments{
\item{indent_by}{How many spaces of indention should be inserted after
operators such as \code{'('}. Unlike \code{styler::tidyverse_style()}, the default is
4 to conform with the Bioconductor coding style.}

\item{...}{Other arguments passed to \code{styler::tidyverse_style()}.}
}
\value{
A \code{list()} object with the information required by functions in
the \code{transformers} argument in the \code{styler} package functions such as
\code{styler::style_pkg()}.
}
\description{
This function uses \code{styler::tidyverse_style()} and modifies it to make it
Bioconductor friendly. The full Bioconductor coding style is described at
\url{https://bioconductor.org/developers/how-to/coding-style/} and it shares
many properties with the Tidyverse coding style guide
\url{https://style.tidyverse.org/}. This function defines the \code{transformers} code
that you can then use with other \code{styler} functions such as
\code{styler::style_pkg()}.
}
\details{
The \code{styler} package seems to be more actively maintained and better
performance than \code{formatR}, though that package can also be useful. This
function does not produce an exact Bioconductor coding style, but it gets
you close enough! =)

For more details on how this function came to be, check
\url{https://github.com/r-lib/styler/issues/636}
\url{https://github.com/Bioconductor/BiocCheck/issues/57}
\url{https://github.com/Bioconductor/bioconductor.org/issues/54}
}
\examples{
\dontrun{
## Run these functions in your package
styler::style_pkg(transformers = biocthis::bioc_style())
styler::style_dir(usethis::proj_path("dev"), transformers = biocthis::bioc_style())
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg()

## Automatically style the example package
styler::style_pkg(pkgdir, transformers = biocthis::bioc_style())
}
