% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDA.R
\name{runDA}
\alias{runDA}
\title{runDA}
\usage{
runDA(method_list, object, weights = NULL, verbose = TRUE)
}
\arguments{
\item{method_list}{a list object containing the methods and their parameters.}

\item{object}{a phyloseq object.}

\item{weights}{an optional numeric matrix giving observational weights.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A named list containing the results for each method.
}
\description{
Run the differential abundance detection methods.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
    "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
    phyloseq::sample_data(metadata))

# Set some simple normalizations
my_norm <- setNormalizations()

# Add them to the phyloseq object
ps <- runNormalizations(normalization_list = my_norm, object = ps)

# Set some limma instances
my_methods <- set_limma(design = ~ group, coef = 2,
    norm = c("TMM", "poscounts", "CSS"))

# Run the methods
results <- runDA(method_list = my_methods, object = ps)
}
