% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_linda.R
\name{DA_linda}
\alias{DA_linda}
\title{DA_linda}
\usage{
DA_linda(
  object,
  assay_name = "counts",
  formula = NULL,
  contrast = NULL,
  is.winsor = TRUE,
  outlier.pct = 0.03,
  zero.handling = c("pseudo-count", "imputation"),
  pseudo.cnt = 0.5,
  alpha = 0.05,
  p.adj.method = "BH",
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{formula}{a character string for the formula. The formula should conform to that used by \code{lm} (independent 
data) or \code{lmer} (correlated data).
 For example: \code{formula = '~x1*x2+x3+(1|id)'}. At least one fixed effect is required.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{is.winsor}{a logical value indicating whether winsorization should be performed to replace outliers (high values).
 The default is TRUE.}

\item{outlier.pct}{the expected percentage of outliers. These outliers will be winsorized. The default is 0.03.}

\item{zero.handling}{a character string of 'pseudo-count' or 'imputation' indicating the zero handling method
used when \code{feature.dat} is 'count'.  If 'pseudo-count', a\code{pseudo.cnt} will be added to each value in \code{feature.dat}. 
If 'imputation', then we use the imputation approach using the formula in the referenced paper. Basically,
zeros are imputed with values proportional to the sequencing depth. When \code{feature.dat} is 'proportion',
this parameter will be ignored and zeros will be imputed by half of the minimum for each feature.}

\item{pseudo.cnt}{a positive numeric value for the pseudo-count to be added if \code{zero.handling}
is 'pseudo-count'. Default is 0.5. }

\item{alpha}{a numerical value between 0 and 1 indicating the significance level 
for declaring differential features. Default is 0.05.}

\item{p.adj.method}{a character string indicating the p-value adjustment approach for 
addressing multiple testing. See R function \code{p.adjust}. Default is 'BH'.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for linda differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_linda(object = ps, formula = "~ group", contrast = c("group", "B", "A"), 
    is.winsor = TRUE, zero.handling = "pseudo-count", verbose = FALSE)
}
\seealso{
\code{\link[MicrobiomeStat]{linda}}.
}
