% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_ZicoSeq.R
\name{DA_ZicoSeq}
\alias{DA_ZicoSeq}
\title{DA_ZicoSeq}
\usage{
DA_ZicoSeq(
  object,
  assay_name = "counts",
  contrast = NULL,
  strata = NULL,
  adj.name = NULL,
  feature.dat.type = c("count", "proportion", "other"),
  is.winsor = TRUE,
  outlier.pct = 0.03,
  winsor.end = c("top", "bottom", "both"),
  is.post.sample = TRUE,
  post.sample.no = 25,
  perm.no = 99,
  link.func = list(function(x) sign(x) * (abs(x))^0.5),
  ref.pct = 0.5,
  stage.no = 6,
  excl.pct = 0.2,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{strata}{a factor such as subject IDs indicating the permutation strata or characters indicating the strata variable in \code{meta.dat}. Permutation will be confined to each stratum. This can be used for paired or some longitudinal designs.}

\item{adj.name}{the name(s) for the variable(s) to be adjusted. Multiple variables are allowed.
       They could be numeric or categorical; should be in \code{meta.dat}.}

\item{feature.dat.type}{the type of the feature data. It could be "count", "proportion" or "other". For "proportion" data type, posterior sampling will not be performed,
but the reference-based ratio approach will still be used to address compositional effects. For "other" data type, neither posterior sampling or reference-base ratio approach
will be used.}

\item{is.winsor}{a logical value indicating whether winsorization should be performed to replace outliers. The default is TRUE.}

\item{outlier.pct}{the expected percentage of outliers. These outliers will be winsorized. The default is 0.03. For count/proportion data, 
\code{outlier.pct} should be less than \code{prev.filter}.}

\item{winsor.end}{a character indicating whether the outliers at the "top", "bottom" or "both" will be winsorized.
The default is "top". If the \code{feature.dat.type} is "other", "both" may be considered.}

\item{is.post.sample}{a logical value indicating whether to perform posterior sampling of the underlying proportions.
 Only relevant when the feature data are counts.}

\item{post.sample.no}{the number of posterior samples if posterior sampling is used. The default is 25.}

\item{perm.no}{the number of permutations. If the raw p values are of the major interest, set \code{perm.no} to at least 999.}

\item{link.func}{a list of transformation functions for the feature data or the ratios. Based on our experience, 
square-root transformation is a robust choice for many datasets.}

\item{ref.pct}{percentage of reference taxa. The default is 0.5.}

\item{stage.no}{the number of stages if multiple-stage normalization is used. The default is 6.}

\item{excl.pct}{the maximum percentage of significant features (nominal p-value < 0.05) in the reference set that should be removed. 
Only relevant when multiple-stage normalization is used.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for ZicoSeq differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 600, size = 3, prob = 0.5), nrow = 100, 
    ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_ZicoSeq(object = ps, feature.dat.type = "count", 
    contrast = c("group", "B", "A"), is.winsor = TRUE, winsor.end = "top", 
    is.post.sample = FALSE, verbose = FALSE)
}
\seealso{
\code{\link[GUniFrac]{ZicoSeq}}.
}
