% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Maaslin2.R
\name{DA_Maaslin2}
\alias{DA_Maaslin2}
\title{DA_Maaslin2}
\usage{
DA_Maaslin2(
  object,
  assay_name = "counts",
  normalization = c("TSS", "CLR", "CSS", "NONE", "TMM"),
  transform = c("LOG", "LOGIT", "AST", "NONE"),
  analysis_method = c("LM", "CPLM", "ZICP", "NEGBIN", "ZINB"),
  correction = "BH",
  random_effects = NULL,
  fixed_effects = NULL,
  contrast = NULL,
  reference = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{normalization}{
    The normalization method to apply.
}

\item{transform}{
    The transform to apply.
}

\item{analysis_method}{
    The analysis method to apply.
}

\item{correction}{
    The correction method for computing the q-value.
}

\item{random_effects}{
    The random effects for the model, comma-delimited for multiple effects.
}

\item{fixed_effects}{
    The fixed effects for the model, comma-delimited for multiple effects.
}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{reference}{
    The factor to use as a reference for a variable with more than two levels
    provided as a string of 'variable,reference'
    semi-colon delimited for multiple variables.
}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for Maaslin2 differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_Maaslin2(object = ps, normalization = "CLR", transform = "NONE",
    analysis_method = "LM", correction = "BH", random_effects = NULL,
    fixed_effects = "group", contrast = c("group", "B", "A"),
    verbose = FALSE)
}
\seealso{
\code{\link[Maaslin2]{Maaslin2}}.
}
