% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeRun.R
\name{summarizeRun}
\alias{summarizeRun}
\title{Summarize MCMC chain and return point estimates for BEER parameters}
\usage{
summarizeRun(
  object,
  jags.files,
  se.matrix,
  burn.in = 0,
  post.thin = 1,
  assay.names = c(phi = NULL, phi_Z = "logfc", Z = "prob", c = "sampleInfo", pi =
    "sampleInfo"),
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object}

\item{jags.files}{list of files containing MCMC sampling results}

\item{se.matrix}{logical matrix indicating which peptides were identified as
super-enriched peptides}

\item{burn.in}{number of iterations to be burned}

\item{post.thin}{thinning parameter}

\item{assay.names}{named vector of specifying where to store point estimates}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}
}
\value{
PhIPData object with point estimates stored in the assays specified
by `assay.names`.
}
\description{
Posterior means are used as point estimates for \eqn{c}, \eqn{\pi},
\eqn{\phi}, and \eqn{Z}. As super-enriched peptides are tossed out before
MCMC sampling, super-enriched peptides return \code{NA} for the \eqn{\phi}
and \eqn{Z} point estimates. Indices corresponding to a particular peptide in
the MCMC sampler are mapped back to the original peptide names.
}
