% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgeR.R
\name{runEdgeR}
\alias{runEdgeR}
\title{Run edgeR on PhIP-Seq data}
\usage{
runEdgeR(
  object,
  threshold.cpm = 0,
  threshold.prevalence = 0,
  assay.names = c(logfc = "logfc", prob = "prob"),
  beadsRR = FALSE,
  de.method = "exactTest",
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{object}{\code{\link[PhIPData]{PhIPData}} object}

\item{threshold.cpm}{CPM threshold to be considered present in a sample}

\item{threshold.prevalence}{proportion of beads-only samples that surpass
\code{threshold.cpm}.}

\item{assay.names}{named vector specifying the assay names for the
log2(fold-change) and exact test p-values. If the vector is not names, the
first and second entries are used as defaults}

\item{beadsRR}{logical value specifying whether each beads-only sample
should be compared to all other beads-only samples.}

\item{de.method}{character describing which edgeR test for differential
expression should be used. Must be one of `exactTest` or `glmQLFTest`}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}
}
\value{
PhIPData object with log2 estimated fold-changes and p-values for
enrichment stored in the assays specified by `assay.names`.
}
\description{
Run edgeR on PhIP-Seq data
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

## Default back-end evaluation
runEdgeR(sim_data)

## Serial
runEdgeR(sim_data, BPPARAM = BiocParallel::SerialParam())

## Snow
runEdgeR(sim_data, BPPARAM = BiocParallel::SnowParam())

## With glmQLFTest
runEdgeR(sim_data, de.method = "glmQLFTest")

}
\seealso{
\code{[BiocParallel::BiocParallelParam]}, \code{\link{beadsRR}}
}
