% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHelpers.R
\name{getExpected}
\alias{getExpected}
\title{Calculate expected read counts or proportion of reads}
\usage{
getExpected(
  object,
  type = c("rc", "prop"),
  assay.names = c("expected_rc", "expected_prop")
)
}
\arguments{
\item{object}{PhIPData object}

\item{type}{any of `rc` or `prop` indicating whether the function should
return the expected read counts or expected proportion of reads, respectively}

\item{assay.names}{name(s) indicating where the results should be stored in the
PhIPData object}
}
\value{
PhIPData object with the results stored in the location specified
by \code{assay.name}.
}
\description{
Calculate expected read counts or proportion of reads
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

## Calculate expected read counts
getExpected(sim_data, "rc", "expected_rc")

## Calculate expected proportion of reads
getExpected(sim_data, "prop", "expected_prop")

## Calculate both
getExpected(sim_data)

}
