% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessEnriched.R
\name{.guessEnrichedEdgeR}
\alias{.guessEnrichedEdgeR}
\title{Guess super-enriched peptides based on edgeR fold-change estimates}
\usage{
.guessEnrichedEdgeR(object, threshold = 15, fc.name = "logfc")
}
\arguments{
\item{object}{\code{\link[PhIPData]{PhIPData}} object.}

\item{threshold}{minimum estimated fc for a peptide to be considered
super-enriched.}

\item{fc.name}{assay name corresponding to the assay that stores the edgeR
estimated log2 fold-changes.}
}
\value{
logical matrix of the with the same dimensions as \code{object}
indicating which peptides are considered super-enriched.
}
\description{
Guess super-enriched peptides based on edgeR fold-change estimates
}
