% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Install conda}
\usage{
download(
  download.version = defaultDownloadVersion(),
  cache.dir = defaultCacheDirectory(),
  ignore.cache = FALSE
)
}
\arguments{
\item{download.version}{String specifying the Miniforge version to download.}

\item{cache.dir}{String specifying the location of the directory in which to cache Miniforge installations.}

\item{ignore.cache}{Logical scalar specifying whether to ignore any existing cached version of Miniforge,
in which case the binaries will be downloaded again.}
}
\value{
A conda instance is created at the cache location. 
Nothing is performed if a complete instance already exists at that location.
A string is returned containing the path to the conda installation.
}
\description{
Install conda via the Miniforge project to an appropriate destination path,
skipping the installation if said path already exists.
}
\details{
This function was originally created from code in \url{https://github.com/hafen/rminiconda},
also borrowing code from \pkg{reticulate}'s \code{install_miniconda} for correct Windows installation.
It downloads and runs a Miniforge installer to create a Bioconductor-managed Conda instance. 

Whenever \code{download} is re-run, any old conda instances and their associated \pkg{basilisk} environments are deleted from the external installation directory.
This avoids duplication of large conda instances after their obselescence.
}
\examples{
download()

}
\author{
Aaron Lun
}
