% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\docType{methods}
\name{reportBCL}
\alias{reportBCL}
\alias{reportBCL.basecallQC}
\alias{reportBCL,baseCallQC-method}
\alias{reportBCL,basecallQC-method}
\title{Generate basecallQC report}
\usage{
\S4method{reportBCL}{basecallQC}(object,reportOut,reportOutDir,output,reportRMDfile,FQQC)

\S4method{reportBCL}{basecallQC}(object = "basecallQC",
  reportOut = "report.html", reportOutDir = getwd(), output = "static",
  reportRMDfile = NULL, FQQC = FALSE)
}
\arguments{
\item{object}{A basecall QC object as returned from basecallQC() function}

\item{reportOut}{Name of report file}

\item{reportOutDir}{Directory for the report file}

\item{output}{Whether the report contains frozen or sortable tables. Options are "static" and "html"}

\item{reportRMDfile}{RMD to be used for reporting. (Default uses standard report template)}

\item{FQQC}{TRUE or FALSE, whether to run ShortRead fastq QC on any fastQ in output directory.}
}
\value{
An HTML report is written to file.
}
\description{
Creates a summary report from basecalling and demultiplexing metrics.
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
reportBCL(bclQC,"TestReport.html",output="html")
}
\author{
Thomas Carroll
}
