% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{passFilterTilePlot}
\alias{passFilterTilePlot}
\alias{passFilterTilePlot.basecallQC}
\alias{passFilterTilePlot,baseCallQC-method}
\alias{passFilterTilePlot,basecallQC-method}
\alias{passFilterTilePlot,list-method}
\title{Tile plot of Illumina basecalling statistics for reads passing filter.}
\usage{
\S4method{passFilterTilePlot}{baseCallQC}(object,metricToPlot)

\S4method{passFilterTilePlot}{basecallQC}(object = "basecallQC",
  metricToPlot = "Yield")

\S4method{passFilterTilePlot}{list}(object = "basecallQC",
  metricToPlot = "Yield")
}
\arguments{
\item{object}{A  basecallQC object or list from call to baseCallMetrics()}

\item{metricToPlot}{Character vector defining which metric will be displayed in plot. Should be either "Yield","Yield30","QualityScoreSum" or "ClusterCount".}
}
\value{
A ggplot2 object.
}
\description{
Produces a plot of metric per Tile for basecalling statistics of reads passing/failing filter.
}
\examples{
fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
plot <- passFilterTilePlot(bclQC,metricToPlot="Yield")
}
\author{
Thomas Carroll and Marian Dore
}
