% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{passFilterBoxplot}
\alias{passFilterBoxplot}
\alias{passFilterBoxplot.basecallQC}
\alias{passFilterBoxplot,baseCallQC-method}
\alias{passFilterBoxplot,basecallQC-method}
\alias{passFilterBoxplot,list-method}
\title{Boxplot of Illumina basecalling statistics for reads passing filter.}
\usage{
\S4method{passFilterBoxplot}{baseCallQC}(object,groupBy,metricToPlot)

\S4method{passFilterBoxplot}{basecallQC}(object = "basecallQC",
  groupBy = c("Lane"), metricToPlot = "Yield")

\S4method{passFilterBoxplot}{list}(object = "basecallQC",
  groupBy = c("Lane"), metricToPlot = "Yield")
}
\arguments{
\item{object}{A  basecallQC object or list from call to baseCallMetrics()}

\item{groupBy}{Character vector of how data is grouped for plotting. Should be either "Project","Sample","Lane","Tile","ReadNumber".}

\item{metricToPlot}{Character vector defining which metric will be displayed in plot. Should be either "Yield","Yield30","QualityScoreSum" or "ClusterCount".}
}
\value{
A ggplot2 object.
}
\description{
Produces a boxplot of basecalling statistics for reads passing filter.
}
\examples{
fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
plot <- passFilterBoxplot(bclQC,groupBy = "Sample")
}
\author{
Thomas Carroll and Marian Dore
}
