% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processInterOps_Functions.R
\docType{methods}
\name{interOpsReport}
\alias{interOpsReport}
\title{Function to parse InterOps files and generate summary reports}
\usage{
interOpsReport(bcl2fastqparams, verbose = TRUE)
}
\arguments{
\item{bcl2fastqparams}{A BCL2FastQparams object.}

\item{verbose}{TRUE or FALSE . TRUE reports progress through file parsing.}
}
\value{
A named list of length 3 containing machine and run information, 
basecalling quality information and demultiplexing information.
}
\description{
Parses the InterOps binary files produced by Illumina's Real Time Analysis sofware and
used by Illumina's SAV sofware.
InterOp binary files contain information on phasing/prephsing, yield,read numbers
and basecalling quality score distributions per cycle.
This interOpsReport functions parses and summarises the InterOps files, TileMetrics.bin and QMetrics.bin, and the 
Stats directory XML files, ConversionStats.xml and DemultiplexingStats.xml.
}
\details{
The interOpsReport function returns a list of machine and run 
information, basecalling quality information and demultiplexing information.
The three named elements are descibed below.  
\itemize{
\item{"machineReport"}{ A data.frame containing information machine and software parameters
}
\item{"sequencingReport"}{ A data.frame of mean cluster density, percentage clusters passing filter, phasing 
and prephasing percentages, number of reads total/passing filter and percent of reads with mean quality score > Q30
grouped by lane and read
}
\item{"demuxReport"}{ A data.frame of demultiplexing results containing yield, number of reads, percentage of reads
with quality scores greater than >Q30 and the percent of total reads per lane.
Results are summarised per lane for samples, underdetermined indexes and all indexes (identifed and unidentified).
}
}
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),verbose=FALSE)

# myRes_BCAGJ8ANXX <- interOpsReport(bcl2fastqparams,verbose=TRUE) 
}
\author{
Thomas Carroll.
}
