% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{BCL2FastQparams-class}
\alias{BCL2FastQparams-class}
\alias{BCL2FastQparams}
\alias{BCL2FastQparams-BCL2FastQparams}
\alias{BCL2FastQparams}
\alias{BCL2FastQparams-BCL2FastQparams}
\title{The Parameters for BCL2FastQparams object.}
\usage{
BCL2FastQparams(runXML = NULL, config = NULL, runDir = NULL,
  outDir = NULL, verbose = TRUE)
}
\arguments{
\item{runXML}{file path to runParameters.xml ,if not specified
looks in top level of run directory.}

\item{config}{file path to config.ini ,if not specified
looks in top level of run directory.}

\item{runDir}{file path to run directory.}

\item{outDir}{file path to out directory.}

\item{verbose}{TRUE or FALSE. Messages on or off. Warnings/errors persist}
}
\value{
A BCL2FastQparams object (See details).
}
\description{
Parameter class and accessors for use with basecallQC

Parameter class and accessors
}
\details{
The BCL2FastQparams object contains slots RunDir, OutDir and RunParameters
\itemize{
\item{"RunDir"}{ Character string specifying the top level Run directory}
\item{"OutDir"}{ Character string specifying the output directory}
\item{"RunParameters"}{ A data.frame containing the information from runParameters.xml (See vignette for more details).
}
}
}
\examples{
fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
BCL2FastQparams(runXML,config,runDir=getwd(),verbose=FALSE)
}
