% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{besselK_boost}
\alias{besselK_boost}
\alias{besselK}
\alias{matern}
\alias{trenchDetcpp}
\alias{trenchInvcpp}
\alias{loglikeGPcpp}
\alias{likelihoodGPcpp}
\alias{gradientrhomatern}
\alias{gradientamatern}
\alias{gradientGPcppmatern}
\alias{LeapfrogGPcppPC}
\alias{sampleGPmeanmaterncpp}
\alias{makeComponent}
\alias{sampleGPmeancpp}
\alias{normalisedData}
\alias{normalisedDatamatern}
\alias{centeredDatamatern}
\alias{componentloglike}
\alias{comploglike}
\alias{comploglikelist}
\alias{sampleDirichlet}
\alias{sampleOutliercpp}
\alias{sampleAlloccpp}
\alias{centeredData}
\alias{mahaInt}
\alias{dmvtInt}
\alias{dmvtCpp}
\alias{gradientGPcpp}
\alias{LeapfrogGPcpp}
\alias{rcpp_pgdraw}
\title{bessel function of the second kind from boost library}
\usage{
besselK_boost(x, v)

besselK(x, v)

matern(nu, a, rho, tau, D)

trenchDetcpp(c)

trenchInvcpp(v)

loglikeGPcpp(Y, Z, A, logcovDet, sigmak, nk, D, Y2)

likelihoodGPcpp(Xk, tau, h, nk, D, materncov = 0L, nu = 2)

gradientrhomatern(Y, drvrhomatern, nk, D, Z, A, sigmak)

gradientamatern(Y, amatern, nk, D, Z, A, sigmak)

gradientGPcppmatern(Xk, tau, h, nk, D, nu)

LeapfrogGPcppPC(Xk, lambda, tau, p, x, m, nk, D, L, delta, nu)

sampleGPmeanmaterncpp(Xk, tau, h, nk, D, nu)

makeComponent(X, BX, Y, BY, j)

sampleGPmeancpp(Xk, tau, h, nk, D)

normalisedData(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j)

normalisedDatamatern(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, j, nu)

centeredDatamatern(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K, nu)

componentloglike(centereddata, sigmak)

comploglike(centereddata, sigmak)

comploglikelist(centereddata, sigmak)

sampleDirichlet(numSamples, alpha)

sampleOutliercpp(allocoutlierprob)

sampleAlloccpp(allocprob)

centeredData(Xknown, BX, Xunknown, BXun, hypers, nk, tau, D, K)

mahaInt(X, mu, sigma, isChol = FALSE)

dmvtInt(X, mu, cholDec, log, df)

dmvtCpp(X_, mu_, sigma_, df_, log_, isChol_)

gradientGPcpp(Xk, tau, h, nk, D)

LeapfrogGPcpp(Xk, tau, p, x, m, nk, D, L, delta)

rcpp_pgdraw(b, c)
}
\arguments{
\item{x}{position}

\item{v}{argument of trench algorithm}

\item{nu}{smoothness parameter of matern covariance}

\item{a}{amplitude}

\item{rho}{length-scale}

\item{tau}{indexing term}

\item{D}{number of samples}

\item{c}{parameter of PG distribution}

\item{Y}{pointer to data to be subset. X and Y will be joined}

\item{Z}{special matrix from trench algorithm (see Crook et al arxiv 2019)}

\item{A}{special matrix from trench algorithm (see Crook et al arxiv 2019)}

\item{logcovDet}{log determine of the covariancematrix}

\item{sigmak}{variance term}

\item{nk}{number of observations}

\item{Y2}{vectorised data (see Crook et al arxiv 2019)}

\item{Xk}{The data}

\item{h}{vector of hyperparamters}

\item{materncov}{logical indicating whether to use matern or gaussian
covariance. Defaults to Guassian covariance}

\item{drvrhomatern}{deterivate of matern covariance wrt to rho}

\item{amatern}{deterivate of matern covariance wrt to amplitude}

\item{lambda}{parameters of penalised complexity prior}

\item{p}{momentum}

\item{m}{mass}

\item{L}{iterations}

\item{delta}{stepsize}

\item{X}{data}

\item{BX}{indexing set to make component}

\item{BY}{pointer to subsetting matrix}

\item{j}{indicator of localisations i.e. niche j}

\item{Xknown}{data with known localisations}

\item{Xunknown}{data with unknown localisations}

\item{BXun}{indexing set for unknown localisations}

\item{hypers}{vector of hyperparameters}

\item{K}{number of components}

\item{centereddata}{pointer to centered data}

\item{numSamples}{The number of samples desired}

\item{alpha}{The concentration parameter}

\item{allocoutlierprob}{The probabilities of being allocated to the outlier
component}

\item{allocprob}{probability of being allocated to particular component}

\item{mu}{mean}

\item{sigma}{variance matrix}

\item{isChol}{boolen indicated whether sigma is cholesky decomposition}

\item{cholDec}{Cholesky decomposition of variance matrix}

\item{log}{boolen of log density}

\item{df}{degrees of freedom for t distribution}

\item{X_}{the data}

\item{mu_}{the mean}

\item{sigma_}{the variance matrix}

\item{df_}{the degrees of freedom}

\item{log_}{return log density (boolean).}

\item{isChol_}{is variance matrix in cholesky decomposition}

\item{b}{parameter of PG distribution}
}
\value{
A numeric indicating the density of the t-distribution
}
\description{
Leapfrog routine

Leapfrog routine
}
\examples{
dmvtCpp(diag(1,1,1), 1, diag(1,1,1), 1, TRUE, TRUE)

}
