% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWrite.R
\name{writeToGTF}
\alias{writeToGTF}
\title{write GRangeslist into GTF file}
\usage{
writeToGTF(annotation, file, geneIDs = NULL)
}
\arguments{
\item{annotation}{a \code{GRangesList} object}

\item{file}{the output gtf file name}

\item{geneIDs}{an optional dataframe of geneIDs (column 2) with
the corresponding transcriptIDs (column 1)}
}
\value{
gtf a GTF dataframe
}
\description{
Write annotation GRangesList into a GTF file
}
\examples{
outputGtfFile <- tempfile()
gr <- readRDS(system.file("extdata",
    "annotationGranges_txdbGrch38_91_chr9_1_1000000.rds",
    package = "bambu"
))
writeToGTF(gr, outputGtfFile)
}
