% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{fit}
\alias{fit}
\alias{fit,Bacon-method}
\title{Method to plot mixture fit}
\usage{
fit(object, index = 1, ...)

\S4method{fit}{Bacon}(object, index, col = "grey75", border = "grey75", ...)
}
\arguments{
\item{object}{'bacon'-object}

\item{index}{if multiple sets of test-statsistics where provided}

\item{...}{additional plotting parameters}

\item{col}{line color default 'grey75'}

\item{border}{border color 'grey75'}
}
\value{
plot of the Gibbs Sampler mixture fit
}
\description{
Method to plot mixture fit
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
##nbins = 100 to speed up the calculations
bc <- bacon(y, nbins=100)
fit(bc)
}
\seealso{
\code{\link{bacon}}
}
