% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bacon.R
\name{bacon}
\alias{bacon}
\title{Gibbs sampler}
\usage{
bacon(
  teststatistics = NULL,
  effectsizes = NULL,
  standarderrors = NULL,
  niter = 5000L,
  nburnin = 2000L,
  nbins = 1000,
  trim = 0.999,
  level = 0.05,
  na.exclude = FALSE,
  verbose = FALSE,
  priors = list(sigma = list(alpha = 1.28, beta = 0.36), mu = list(lambda = c(0, 3, -3),
    tau = c(1000, 100, 100)), epsilon = list(gamma = c(90, 5, 5))),
  globalSeed = 42,
  parallelSeed = 42
)
}
\arguments{
\item{teststatistics}{numeric vector or matrix of test-statistics}

\item{effectsizes}{numeric vector or matrix of effect-sizes}

\item{standarderrors}{numeric vector or matrix of standard errors}

\item{niter}{number of iterations}

\item{nburnin}{length of the burnin period}

\item{nbins}{default 1000 else bin test-statistics}

\item{trim}{default 0.999 trimming test-statistics}

\item{level}{significance level used to determine prop. null for
starting values}

\item{na.exclude}{see ?na.exclude}

\item{verbose}{default FALSE}

\item{priors}{list of parameters for the prior distributions}

\item{globalSeed}{default 42 global seed. If set to NULL,
randomization will occur for sequential and parallel bacon calls}

\item{parallelSeed}{default 42 BiocParallel RNGseed. If input
statistics are a matrix and globalSeed=NULL, setting
parallelSeed=NULL will allow randomization across parallel
processes within a bacon call and across separate calls to bacon.}
}
\value{
object of class-Bacon
}
\description{
Gibbs Sampler Algorithm to fit a three component normal mixture to
z-scores
}
\examples{
##simulate some test-statistic from a normal mixture
##and run bacon
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
bc <- bacon(y)
##extract all estimated mixture parameters
estimates(bc)
##extract inflation
inflation(bc)
##extract bias
bias(bc)

##extract bias and inflation corrected test-statistics
head(tstat(bc))

##inspect the Gibbs Sampling output
traces(bc)
posteriors(bc)
fit(bc)

##simulate multiple sets of test-statistic from a normal mixture
##and run bacon
y <- matrix(rnormmix(10*2000, c(0.9, 0, 1, 0, 4, 1)), ncol=10)
bc <- bacon(y)
##extract all estimated mixture parameters
estimates(bc)
##extract only the inflation
inflation(bc)
##extract only the bias
bias(bc)
##extract bias and inflation corrected P-values
head(pval(bc))
##extract bias and inflation corrected test-statistics
head(tstat(bc))
}
\references{
Implementation is based on a version from Zhihui Liu
    \url{https://macsphere.mcmaster.ca/handle/11375/9368}
}
\author{
mvaniterson
}
