% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_linmod_limma.R
\name{summarize_fit}
\alias{summarize_fit}
\alias{summarize_fit.data.table}
\alias{summarize_fit.SummarizedExperiment}
\title{Summarize fit}
\usage{
summarize_fit(object, ...)

\method{summarize_fit}{data.table}(
  object,
  fit = fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  ...
)

\method{summarize_fit}{SummarizedExperiment}(
  object,
  fit = fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  ...
)
}
\arguments{
\item{object}{SummarizedExperiment or data.table}

\item{...}{S3 dispatch}

\item{fit}{'limma', 'lme', 'lm', 'lme', 'wilcoxon' or NULL}

\item{coefs}{string vector}
}
\value{
data.table(contrast, nup, ndown)
}
\description{
Summarize fit
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% linmod_limma()
object \%<>\% linmod_lm()
summarize_fit(object, coefs = c('t1-t0', 't2-t0', 't3-t0'))
}
