% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_pca.R
\name{scoremat}
\alias{scoremat}
\alias{scores}
\alias{loadingmat}
\alias{loadings}
\title{Extract scores/loadings}
\usage{
scoremat(object, method = "pca", by = biplot_by(object, method), dim = 1:2)

scores(object, method = "pca", by = biplot_by(object, method), dim = 1)

loadingmat(object, method = "pca", by = biplot_by(object, method), dim = 1:2)

loadings(object, method = "pca", by = biplot_by(object, method), dim = 1)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{method}{'pca', 'pls', etc.}

\item{by}{svar (string)}

\item{dim}{numeric vector}
}
\description{
Extract scores/loadings
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% pca()
    scores(object)[1:2]
  loadings(object)[1:2]
  scoremat(object)[1:2, ]
loadingmat(object)[1:2, ]
}
