% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15_read_somascan.R
\name{read_olink}
\alias{read_olink}
\title{Read olink file}
\usage{
read_olink(file, sample_excel = NULL, sample_tsv = NULL, by.y = "SampleID")
}
\arguments{
\item{file}{olinkfile}

\item{sample_excel}{sample excel}

\item{sample_tsv}{sample tsv}

\item{by.y}{sample tsv   mergeby column}
}
\value{
SummarizedExperiment
}
\description{
Read olink file
}
\examples{
# Example data
    npxdt   <- data.table::data.table(OlinkAnalyze::npx_data1)[, c(1:11, 17)]
    sampledt <- data.table::data.table(OlinkAnalyze::npx_data1)[, c(1, 12:15)]
    sampledt \%<>\% extract(!grepl('CONTROL', SampleID))
    sampledt \%<>\% unique()
# Write to file
    file <- paste0(tempfile(), '.olink.csv')
    samplefile <- paste0(tempfile(), '.samples.xlsx')
    data.table::fwrite(npxdt, file)
    writexl::write_xlsx(sampledt, samplefile)
# Read
    object <- read_olink(file, sample_excel = samplefile)
    biplot(pca(object), color = 'Time', group = 'Subject', shape = 'Treatment')
}
