% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_read_proteingroups.R
\name{read_maxquant_phosphosites}
\alias{read_maxquant_phosphosites}
\alias{read_phosphosites}
\title{Read maxquant phosphosites}
\usage{
read_maxquant_phosphosites(
  dir = getwd(),
  fosfile = if (is_file(dir)) dir else file.path(dir, "phospho (STY)Sites.txt"),
  profile = file.path(dirname(fosfile), "proteinGroups.txt"),
  fastafile = NULL,
  restapi = FALSE,
  quantity = NULL,
  subgroups = NULL,
  invert = character(0),
  rm_contaminants = TRUE,
  rm_reverse = TRUE,
  rm_missing_in_all_samples = TRUE,
  localization = 0.75,
  impute = FALSE,
  plot = FALSE,
  label = "feature_id",
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  formula = as.formula("~ subgroup"),
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)

read_phosphosites(...)
}
\arguments{
\item{dir}{proteingroups directory}

\item{fosfile}{phosphosites  file}

\item{profile}{proteingroups file}

\item{fastafile}{uniprot fastafile}

\item{restapi}{TRUE or FALSE : annotate non-fastadt uniprots using uniprot restapi}

\item{quantity}{'normalizedratio', 'ratio', 'correctedreporterintensity', 
'reporterintensity', 'maxlfq', 'labeledintensity', 
'intensity' or NULL}

\item{subgroups}{NULL or string vector : subgroups to retain}

\item{invert}{string vector: subgroups which require inversion}

\item{rm_contaminants}{TRUE or FALSE: rm contaminants ?}

\item{rm_reverse}{TRUE or FALSE: rm reverse proteins ?}

\item{rm_missing_in_all_samples}{TRUE or FALSE}

\item{localization}{number: min localization probability (for phosphosites)}

\item{impute}{TRUE or FALSE: impute group-specific NA values?}

\item{plot}{TRUE or FALSE}

\item{label}{fvar}

\item{pca}{TRUE or FALSE: run pca ?}

\item{pls}{TRUE or FALSE: run pls ?}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)', 'wilcoxon' or NULL}

\item{formula}{model formula}

\item{block}{model blockvar: string or NULL}

\item{coefs}{model coefficients          of interest: string vector or NULL}

\item{contrasts}{model coefficient contrasts of interest: string vector or NULL}

\item{palette}{color palette: named string vector}

\item{verbose}{TRUE or FALSE: message ?}

\item{...}{maintain deprecated functions}
}
\value{
SummarizedExperiment
}
\description{
Read maxquant phosphosites
}
\examples{
  profile <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
  fosfile <- system.file('extdata/billing19.phosphosites.txt',  package = 'autonomics')
fastafile <- system.file('extdata/uniprot_hsa_20140515.fasta',  package = 'autonomics')
subgroups <- sprintf('\%s_STD', c('E00', 'E01', 'E02', 'E05', 'E15', 'E30', 'M00'))
pro <- read_maxquant_proteingroups(file = profile, subgroups = subgroups)
fos <- read_maxquant_phosphosites(fosfile = fosfile, profile = profile, subgroups = subgroups)
fos <- read_maxquant_phosphosites(fosfile = fosfile, profile = profile, fastafile = fastafile, subgroups = subgroups)
}
