% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{artmsWriteConfigYamlFile}
\alias{artmsWriteConfigYamlFile}
\title{Write out a template file of the artMS configuration file (yaml)}
\usage{
artmsWriteConfigYamlFile(
  config_file_name = "artms_config_file.yaml",
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{config_file_name}{(char) The name for the configuration file. It must
have a \code{.yaml} extension. If \code{NULL}, it returns the config as a yaml object}

\item{overwrite}{(logical) Default FALSE}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
A file (or yaml data object) of the artMS configuration file
}
\description{
Creates a template file of the artMS configuration file, which
is required to run \code{artmsQuantification}. Check \code{?artms_config} and the
vignettes to find out more about the details of the structure of the file
and how to fill it up
}
\examples{
config_empty <- artmsWriteConfigYamlFile(config_file_name = NULL)
}
\keyword{config,}
\keyword{yaml}
