% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstats_functions.R
\name{artmsChangeColumnName}
\alias{artmsChangeColumnName}
\title{Change a specific column name in a given data.frame}
\usage{
artmsChangeColumnName(dataset, oldname, newname)
}
\arguments{
\item{dataset}{(data.frame) with the column name you want to change}

\item{oldname}{(char) the old column name}

\item{newname}{(char) the new name for that column}
}
\value{
(data.frame) with the new specified column name
}
\description{
Making easier to change a column name in any data.frame
}
\examples{
artms_data_ph_evidence <- artmsChangeColumnName(
                               dataset = artms_data_ph_evidence,
                               oldname = "Phospho..STY.",
                               newname = "PH_STY")
}
\keyword{columns}
\keyword{data.frame,}
\keyword{rename,}
