% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqSelSigGenes.R
\name{anota2seqSelSigGenes}
\alias{anota2seqSelSigGenes}
\title{Select identifiers from the output of \code{anota2seqAnalyze}.}
\usage{
anota2seqSelSigGenes(Anota2seqDataSet, useRVM = TRUE,
  analysis = anota2seqGetAvailableAnalyzes(Anota2seqDataSet),
  selIds = NULL, selContrast = seq(along =
  1:dim(anota2seqGetContrasts(Anota2seqDataSet))[2]),
  minSlopeTranslation = NULL, maxSlopeTranslation = NULL,
  minSlopeBuffering = NULL, maxSlopeBuffering = NULL, slopeP = NULL,
  minEff = NULL, maxP = NULL, maxPAdj = NULL, selDeltaPT = NULL,
  selDeltaTP = NULL, selDeltaP = NULL, selDeltaT = NULL,
  sortBy = c("rvmP", "none", "Eff", "p"))
}
\arguments{
\item{Anota2seqDataSet}{An Anota2seqDataSet containing the output from 
the anota2seqAnalyze function performed on the analysis to be filtered 
by anota2seqSelSigGenes.}

\item{useRVM}{If a significance threshold is provided (maxP or maxPAdj, 
see below), should the output be filtered on Random Variance Model 
p-values or on non-RVM p-values? Default is TRUE i.e. RVM p-values.}

\item{analysis}{A vector of character string(s) specifying which 
analysis(es) should be considered for filtering. Should be at least one
of the following: "translated mRNA", "total mRNA", "translation" or 
"buffering". By default, filtering will be performed on all available 
analyzes in the Anota2seqDataSet object.}

\item{selIds}{The function can consider only a subset of the identifiers 
from the input data set. For custom selection of identifiers, supply a
vector of identifiers (row names from the original data set) to be
included. Default is NULL i.e. filtering is performed on all
identifiers.}

\item{selContrast}{Which contrast(s) should be evaluated during the 
filtering and sorting? Descriptions of the contrasts can be found in
the output from the anota2seqAnalyze object in the usedContrasts slot.
Indicate the contrast(s) by a numeric vector of the column number(s).
By default, all available contrasts in the Anota2seqDataSet object are
filtered.}

\item{minSlopeTranslation}{The output can be filtered so that identifiers
whose identified slopes in analysis of changes in translational 
efficiency leading to altered protein levels are too small can be 
excluded. Default is NULL i.e. no filtering based on lower boundary of 
the slope. To exclude identifiers with e.g. a slope <(-1), assign -1 to
minSlopeTranslation. Only applied when analysis is set to 
"translation".}

\item{maxSlopeTranslation}{The output can be filtered so that identifiers
whose identified slopes in analysis of changes in translational 
efficiency leading to altered protein levels are too large can be 
excluded. Default is NULL i.e. no filtering based on upper boundary of 
the slope. To exclude identifiers with e.g. a slope >2, assign 2 to 
maxSlopeTranslation. Only applied when analysis is set to 
"translation".}

\item{minSlopeBuffering}{The output can be filtered so that identifiers 
whose identified slopes in analysis of changes in translational 
efficiency leading to buffering are too small can be excluded. Default 
is NULL i.e. no filtering based on lower boundary of the slope. To 
exclude identifiers with e.g. a slope <(-2), assign -2 to 
minSlopeBuffering Only applied when analysis is set to "buffering".}

\item{maxSlopeBuffering}{The output can be filtered so that genes whose 
identified slopes in analysis of changes in translational efficiency 
leading to buffering are too large can be excluded. Default is NULL 
i.e. no filtering based on upper boundary of the slope. To exclude 
identifiers with e.g. a slope > 1, assign 1 to maxSlopeBuffering. Only 
applied when analysis is set to "buffering".}

\item{slopeP}{A p-value for the slope being <0 or >1 if the estimate for 
the slope is <0 or >1 (for translation) and <-1 or >0 if the estimate 
for the slope is <-1 or >0 (for buffering). This p-value can be used to
filter the output based on unrealistic slopes. When set low, fewer 
identifiers will be disqualified. Default is NULL i.e. no filtering 
based on slope p-value. Only applied for when analysis is set to 
"translation" or "buffering".}

\item{minEff}{The output can be filtered based on minimum effect for 
inclusion. The value is applied both to negative and positive effects: 
e.g. a value of 1 will evaluate if the effects are >1 OR <(-1). Default
is NULL i.e. no filtering based on effect.}

\item{maxP}{The output can be filtered based on raw p-values from the 
anota2seq analysis (i.e. smaller compared to assigned value). If useRVM
is set to TRUE, filtering will be performed on RVM values, otherwise 
filtering will be performed on non-RVM values. Default is NULL i.e. no 
filtering.}

\item{maxPAdj}{The output can be filtered based on adjusted p-values from
the anota2seq analysis (i.e. smaller compared to assigned value). If 
useRVM is set to TRUE, filtering will be performed on RVM values, 
otherwise filtering will be performed on non-RVM values. The adjustment
method that was used when running anota2seqAnalyze will be evaluated. 
Default is NULL i.e. no filtering.}

\item{selDeltaPT}{The output can be filtered based on the mean 
log2(translation data (e.g. polysome-associated mRNA) / total mRNA 
data) between treatments difference. The treatments are defined by the 
selected contrast. Default is NULL i.e. no filtering. Only applied when
analysis is set to "translation".}

\item{selDeltaTP}{The output can be filtered based on the mean log2(total
mRNA / translation data (e.g. polysome-associated mRNA)) between 
treatments difference. The treatments are defined by the selected 
contrast. Default is NULL i.e. no filtering. Only applied when analysis
is set to "buffering".}

\item{selDeltaP}{The output for analysis changes in translational 
efficiency leading to altered protein levels can be filtered based on 
the translation data only so that the minimum absolute difference 
between treatments for translated mRNA data (e.g. polysome-associated 
mRNA) is used for inclusion. The treatments are defined by the selected
contrast. Default is NULL i.e. no filtering. Use when analysis 
parameter is set to "translation" (i.e. changes in translational 
efficiency leading to altered protein levels) or "translated mRNA".}

\item{selDeltaT}{The output for analysis of changes in translational 
efficiency leading to buffering can be filtered based on the total mRNA
data only so that the minimum absolute difference between treatments 
for buffering is used for inclusion. The treatments are defined by the 
selected contrast. Default is NULL i.e. no filtering. Use when analysis
parameter is set to "buffering" or "total mRNA".}

\item{sortBy}{The output can be sorted by effect ("Eff"), raw p-value
("p"), raw RVM p-value ("rvmP") or not sorted ("none"). Default is "rvmP" when useRVM is set to TRUE and "p" when useRVM is set to FALSE.}
}
\value{
An Anota2seqDataSet. anota2seqSelSigGenes saves its output data 
  in the 'selectedTranslatedmRNA', 'selectedTotalmRNA', 
  'selectedTranslation' and 'selectedBuffering' slots of the 
  Anota2seqDataSet when analysis is set to "translated mRNA", "total 
  mRNA", "translation" and "buffering" respectively. This output contains
  statistics from the applied APV model on selected genes, see 
  \code{\link{anota2seqGetOutput}} for a detailed description.
}
\description{
This function filters the output based on significance 
  threshold, effect sizes (of total mRNA, translated mRNA, translation, 
  buffering), identifier names and/or APV regression slopes.
}
\examples{

data(anota2seq_data)
# Initialize the Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Run analysis of changes in translational efficiency leading to 
# altered protein levels
Anota2seqDataSet <- anota2seqAnalyze(
    Anota2seqDataSet,
    analysis = c("translation"))
# Select significant genes (with a FDR threshold of 0.15) for changes 
# in translational efficiency leading to altered protein level
Anota2seqDataSet <- anota2seqSelSigGenes(Anota2seqDataSet,
                                         maxPAdj = .15) 
}
\seealso{
\code{\link{anota2seqAnalyze}}, 
  \code{\link{anota2seqGetOutput}}
}
