% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weaveWeb-methods.R
\name{weaveWeb-methods}
\alias{weaveWeb-methods}
\alias{weaveWeb.character}
\alias{weaveWeb.formula}
\alias{weaveWeb.MultiAssayExperiment}
\alias{weaveWeb.TreeSumarizedExperiment}
\alias{weaveWeb.SingleCellExperiment}
\title{Weave an AnansiWeb}
\arguments{
\item{x, y}{\verb{Character scalar}, names of feature types that should be
linked. Should be found in the column names of \code{link}.}

\item{link}{One of the following:
\itemize{
\item \verb{Character scalar} with value \code{"none"}.
\item \code{data.frame} with two columns
\item \code{list} with two such \code{data.frame}s.
}}

\item{tableY, tableX}{A table containing features of interest. Rows should be
samples and columns should be features. Y and X refer to the position of
the features in a formula: Y ~ X. \cr
< For Bioconductor S4 objects > \cr
\verb{Character scalar} or \verb{numeric scalar}. Selects experiment
corresponding to \code{tableY} and \code{tableX} from \code{experiments(x)} of
\code{MultiAssayExperiment} object by name or index, name is recommended.
(Default slots: \code{Y = 1L}, \code{X = 2L}).}

\item{metadata}{Optional \code{data.frame} of sample metadata, to be included with
output. Can be accessed from \code{AnansiWeb} generated by \code{weaveWeb()} with
\code{output@metadata}.}

\item{verbose}{\verb{Logical scalar}. Whether to print diagnostic information
(Default: \code{TRUE}).#' @param force_new \code{boolean} If x already has a
dictionary \code{Matrix} in metadata, ignore it and generate a new object
anyway? (Default: FALSE).}

\item{typeY, typeX}{\verb{Character scalar} or \verb{numeric scalar}. Selects assay from experiments to
\code{tableY} and \code{tableX} from \code{experiments(x)}. (Default: \code{1L} - the first assay
in that experiment).}

\item{experiment1, experiment2}{synonymous args to \verb{tableY,tableX} for
compatibility with \code{mia} argument style.}

\item{assay.type1, assay.type2}{synonymous args to \verb{typeY,typeX} for
compatibility with \code{mia} argument style.}
}
\value{
an \code{AnansiWeb} object, with sparse binary biadjacency matrix
with features from \code{y} as rows and features from \code{x} as columns in
\code{dictionary} slot.
}
\description{
Generate a biadjacency matrix, linking the features between two tables.
Return an \code{AnansiWeb} object which contains all three.

\code{weaveWeb()} is for general use and has flexible default settings.

\code{weaveKEGG()} is a wrapper that sets \code{link} to \code{kegg_link()}.
All variants are special cases of \code{weaveWeb()}.
}
\details{
If the \code{link} argument is \code{"none"}, all features will be considered
linked. If one or more \code{data.frame}s, colnames should be as specified in
\code{x} and \code{y}.
}
\examples{
# Setup demo tables, see first vignette.
data(FMT_data)

t1 <- t(FMT_metab)
t2 <- t(FMT_KOs)

# Input objects and syntax:
## define `x` and `y` as characters
web <- weaveWeb(
    x = "ko", y = "cpd", link = kegg_link(),
    tableX = t2, tableY = t1,
    metadata = NULL, verbose = TRUE
)

## define `x` and `y` with a formula
web2 <- weaveWeb(
    x = cpd ~ ko, link = kegg_link(),
    tableX = t2, tableY = t1,
    metadata = NULL, verbose = TRUE
)

identical(web, web2)

# Method for MultiAssayExperiment S4 object
mae <- asMAE(web)
weaveWeb(
    x = mae, link = kegg_link(),
    tableY = "cpd", tableX = "ko",
    force_new = FALSE
)

# Method for TreeSummarizedExperiment S4 object
tse <- asTSE(web)
weaveWeb(
    x = tse, link = kegg_link(),
    tableY = "cpd", tableX = "ko",
    force_new = FALSE
)

}
\seealso{
\itemize{
\item \link{AnansiWeb}: For general constructor and methods.
\item \code{\link[=kegg_link]{kegg_link()}}: For examples of input for link argument.
}
}
