% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_filters.R
\name{goodBaseQuality}
\alias{goodBaseQuality}
\title{Filters out sequences which have bad base quality readings.}
\usage{
goodBaseQuality(reads, min = 20, batch_size = 1e+07)
}
\arguments{
\item{reads}{(ShortRead object) Loaded reads from fastq.}

\item{min}{(numeric) This is the minimum quality that we accept for
every nucleotide. For example, if we have a sequence with nucleotides which
have quality 50-50-50-50-10, and we set the minimum to 30, the whole sequence
will be a bad sequence.}

\item{batch_size}{(numeric) How many reads to process at a time.}
}
\value{
(boolean) Logical vector with the valid rows as TRUE.
}
\description{
Filters out sequences which have bad base quality readings.
}
\keyword{internal}
