% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanNormalize.R
\name{amplicanNormalize}
\alias{amplicanNormalize}
\title{Remove events that can be found in Controls.}
\usage{
amplicanNormalize(
  aln,
  cfgT,
  add = c("guideRNA", "Group"),
  skip = c("counts", "score", "seqnames", "read_id", "strand", "overlaps", "consensus"),
  min_freq = 0.01
)
}
\arguments{
\item{aln}{(data.frame) Contains events from alignments.}

\item{cfgT}{(data.frame) Config table with information about experiments.}

\item{add}{(character vector) Columns from cfgT that should be included
in event table for normalization matching. Defaults to c("guideRNA", "Group")
, which means that only those events created by the same guideRNA in the same
Group will be removed if found in Control.}

\item{skip}{(character vector) Specifies which columns of aln to skip.}

\item{min_freq}{(numeric) All events from control group below this frequency
will be not included in filtering. Use this to filter out background noise
and sequencing errors.}
}
\value{
(data.frame) Same as aln, but events are normalized. Events from
Control are not changed. Additionally columns from add are added to the
data.frame.
}
\description{
This function can adjust events for small differences between
known annotations (amplicon sequences) and real DNA of the strain that
was sequenced. Events from the control are grouped by \code{add} and
their frequencies are calculated in respect to number of total reads in that
groups. In next step events from the control are filtered according to
\code{min_freq}, all events below are treated as sequencing errors and
rejected. Finally, all events that can be found in treatment group that find
their exact match (by non skipped columns) in control group are removed.
All events from control group are returned back.
}
\examples{
aln <- data.frame(seqnames = 1:5, start = 1, end = 2, width = 2,
                  counts = 101:105)
cfgT <- data.frame(ID = 1:5, guideRNA = rep("ACTG", 5),
                   Reads_Filtered = c(2, 2, 3, 3, 4),
                   Group = c("A", "A", "B", "B", "B"),
                   Control = c(TRUE, FALSE, TRUE, FALSE, FALSE))
# all events are same as in the control group, therefore are filtered out
# events from control groups stay
amplicanNormalize(aln, cfgT)
# events that are different from control group are preserved
aln[2, "start"] <- 3
amplicanNormalize(aln, cfgT)

}
\seealso{
Other analysis steps: 
\code{\link{amplicanAlign}()},
\code{\link{amplicanConsensus}()},
\code{\link{amplicanFilter}()},
\code{\link{amplicanMap}()},
\code{\link{amplicanOverlap}()},
\code{\link{amplicanPipeline}()},
\code{\link{amplicanPipelineConservative}()},
\code{\link{amplicanReport}()},
\code{\link{amplicanSummarize}()}
}
\concept{analysis steps}
