% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlevinKneeNbrGenes.R
\name{plotAlevinKneeNbrGenes}
\alias{plotAlevinKneeNbrGenes}
\title{Knee plot of the number of detected genes per cell}
\usage{
plotAlevinKneeNbrGenes(cbTable, firstSelColName = "inFirstWhiteList")
}
\arguments{
\item{cbTable}{\code{data.frame} (such as the \code{cbTable} returned by
\code{readAlevinQC} or \code{readAlevinFryQC}) with the number of
detected genes per cell.}

\item{firstSelColName}{Character scalar indicating the name of the logical
column in \code{cbTable} that corresponds to the original selection of
barcodes for quantification.}
}
\value{
A ggplot object
}
\description{
Plot the number of detected genes per cell in decreasing order.
Only cells contained in the original whitelist are considered.
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                                   package = "alevinQC"))
plotAlevinKneeNbrGenes(alevin$cbTable)

}
\author{
Charlotte Soneson
}
