% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVCF.R
\name{readVCF}
\alias{readVCF}
\alias{loadVCF}
\alias{loadVCFHeader}
\title{Read a VCF object from disk}
\usage{
readVCF(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, usually generated by the \code{\link{saveObject}} method for \linkS4class{VCF} object.s}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{VCF} object.
}
\description{
Read a \linkS4class{VCF} object from its on-disk representation.
}
\examples{
fl <- system.file("extdata", "structural.vcf", package="VariantAnnotation")
vcf <- readVcf(fl)

tmp <- tempfile()
saveObject(vcf, tmp)
readObject(tmp)

}
\seealso{
\code{\link{saveObject,VCF-method}}, to save VCF objects to disk.
}
\author{
Aaron Lun
}
