% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{saveObject,sf-method}
\alias{saveObject,sf-method}
\title{Save \code{sf} to disk for \code{alabaster}}
\usage{
\S4method{saveObject}{sf}(x, path)
}
\arguments{
\item{x}{A Bioconductor object of the specified class.}

\item{path}{String containing the path to a directory in which to save \code{x}.}
}
\value{
x is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
\code{sf} data frames are saved as GeoParquet.
}
\examples{
library(sf)
fp <- tempfile()
df <- as.data.frame(matrix(rnorm(10), ncol = 2))
df <- st_as_sf(df, coords = names(df), crs = NA)
saveObject(df, path = fp)

}
