% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summaryAllelicRatio}
\alias{summaryAllelicRatio}
\title{Allelic ratio summary}
\usage{
summaryAllelicRatio(sce, genecluster)
}
\arguments{
\item{sce}{SingleCellExperiment}

\item{genecluster}{an optional vector of gene cluster IDs.
if nothing is given, all cluster's summaries will be
calculated}
}
\value{
a list of gene cluster summary tables containing:
\itemize{
  \item{weighted.mean} {weighted mean of allelic ratio for the cell types}
  \item{mean} {mean allelic ratio for the cell types}
  \item{var} {variance of allelic ratio for the cell types}
}
}
\description{
Oroduce allelic ratio summaries for each gene cluster
}
\examples{

library(S4Vectors)
sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = 1:4)
summary <- summaryAllelicRatio(sce, genecluster = c(1, 3))
summary
}
