% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adductQuant.R
\name{adductQuant}
\alias{adductQuant}
\title{Adduct quantification for adductomicsR}
\usage{
adductQuant(nCores = NULL, targTable = NULL, 
intStdRtDrift = NULL, rtDevModels = NULL, 
filePaths = NULL, quantObject = NULL, indivAdduct = NULL, maxPpm = 4,
minSimScore = 0.8, spikeScans = 2, minPeakHeight = 100, maxRtDrift = 20,
maxRtWindow = 120, isoWindow = 80, 
hkPeptide = "LVNEVTEFAK", gaussAlpha = 16)
}
\arguments{
\item{nCores}{number of cores to use for analysis. 
If NULL then 1 core will be used.}

\item{targTable}{is the fullpath to the target table. 
See inst/extdata/examplePeptideTargetTable.csv for an example.}

\item{intStdRtDrift}{the maximum drift for the internal standard in seconds.
Default = NULL and therefore no RT correction is applied to the internal
standard.}

\item{rtDevModels}{is the full path to the rtDevModels.RData file
from rtDevModels(). default is NULL and therefore has no RT correction.}

\item{filePaths}{required list of mzXML files for analysis. 
If all files are in the
same directory these can be accessed using
list.files('J:\\parentdirectory\\directoryContainingfiles',
pattern='.mzXML', all.files=FALSE, full.names=TRUE).}

\item{quantObject}{character string for filepath to an 
AdductQuantif object to be integrated.}

\item{indivAdduct}{numeric vector of AdductQuantif targets to re-integrate}

\item{maxPpm}{numeric for the maximum parts per million to be used.}

\item{minSimScore}{a numeric between 0}

\item{spikeScans}{a numeric for the number of scans that a spike
must be seen in for it to be integrated. Default is 2.}

\item{minPeakHeight}{numeric to determine the minimum height for a 
peak to be integrated. Default
is set low at 100.}

\item{maxRtDrift}{numeric for the maximum retention time
drift to be considered. Default is 20.}

\item{maxRtWindow}{numeric in
seconds for the retention time window (total window will be 2 times 
this value)}

\item{isoWindow}{numeric for the pepide isotope window in seconds,
default is 80}

\item{hkPeptide}{is capitalized string for the housekeeping peptide.
The default is 'LVNEVTEFAK' from human serum albumin.}

\item{gaussAlpha}{numeric for the gaussian smoothing parameter to 
smooth the peaks. Default is 16.  
Output is an adductQuantf object saved to the working directory}
}
\value{
adductQuant object
}
\description{
reads mzXML files from a directory, corrects RT according
to RT correction model and quantifies peaks.
}
\examples{
\dontrun{
eh = ExperimentHub();
temp = query(eh, 'adductData');
adductQuant(nCores=2, targTable=paste0(system.file("extdata", 
package = "adductomicsR"),'/exampletargTable2.csv'), intStdRtDrift=30, 
rtDevModels=paste0(hubCache(temp),"/rtDevModels.RData"),
filePaths=list.files(hubCache(temp),pattern=".mzXML", all.files=FALSE,
full.names=TRUE)[1],quantObject=NULL,
indivAdduct=NULL,maxPpm=5,minSimScore=0.8,spikeScans=1,
minPeakHeight=100,maxRtDrift=20,maxRtWindow=240,isoWindow=80,
hkPeptide='LVNEVTEFAK', gaussAlpha=16)
}}
