% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbSeqCRep.R
\docType{class}
\name{AbSeqCRep-class}
\alias{AbSeqCRep-class}
\alias{AbSeqCRep}
\title{S4 class - AbSeqCompositeRepertoire analysis object}
\value{
AbSeqCRep
}
\description{
AbSeqCRep is a collection of \linkS4class{AbSeqRep} S4 objects.
This S4 class contains multiple samples(repertoires) and it can be
"combined" with other samples by using the \code{+} operator to
create an extended \linkS4class{AbSeqCRep} object.
This value, in turn, can be used as the first argument to
\link{report} which generates a comparison between all samples included
in the \code{+} operation.

Users do not manually construct this class, but rather indirectly obtain
this class object as a return value from the \code{+} operation between two
\linkS4class{AbSeqRep} objects, which are in turn, obtained indirectly from
\link{abseqReport} and \link{report} functions. It is also possible to
obtain this class object by \code{+} (adding) \linkS4class{AbSeqCRep} objects.
}
\section{Slots}{

\describe{
\item{\code{repertoires}}{list of \linkS4class{AbSeqRep} objects.}
}}

\examples{
# Use example data from abseqR as abseqPy's output, substitute this
# with your own abseqPy output directory
abseqPyOutput <- tempdir()
file.copy(system.file("extdata", "ex", package = "abseqR"), abseqPyOutput, recursive=TRUE)
samples <- abseqReport(file.path(abseqPyOutput, "ex"), report = 0)

# The provided example data has PCR1, PCR2, and PCR3 samples contained within
# pcr12 and pcr13 are instances of AbSeqCRep
pcr12 <- samples[["PCR1"]] + samples[["PCR2"]]
pcr13 <- samples[["PCR1"]] + samples[["PCR3"]]

# all_S is also an instance of AbSeqCRep
all_S <- pcr12 + pcr13
}
\seealso{
\linkS4class{AbSeqRep}
}
