% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotationTable.R, R/xtable.methods.R
\docType{methods}
\name{xtable,annotationTable,missing,missing,missing,missing,missing-method}
\alias{xtable,annotationTable,missing,missing,missing,missing,missing-method}
\alias{xtable,annotationTable,ANY,ANY,ANY,ANY,ANY-method}
\alias{xtable,annotationTable,ANY,ANY,ANY,numeric,ANY-method}
\alias{xtable-methods}
\alias{xtable.topTableGlmnet}
\alias{xtable.topTableLognet}
\alias{xtable.topTableElnet}
\alias{xtable.pamClassConfusionTable}
\alias{xtable.topTablePam}
\alias{xtable.topTableRfClass}
\title{Methods for Function xtable in Package `annotationTable'}
\usage{
\S4method{xtable}{annotationTable,missing,missing,missing,missing,missing}(x, caption, label, align, digits, display)

\S4method{xtable}{annotationTable,ANY,ANY,ANY,ANY,ANY}(x, caption, label, align, digits, display)

\S4method{xtable}{annotationTable,ANY,ANY,ANY,numeric,ANY}(x, caption, label, align, digits, display)

\method{xtable}{topTableGlmnet}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  ...
)

\method{xtable}{topTableLognet}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  ...
)

\method{xtable}{topTableElnet}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  ...
)

\method{xtable}{pamClassConfusionTable}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  ...
)

\method{xtable}{topTablePam}(x, ...)

\method{xtable}{topTableRfClass}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  ...
)
}
\arguments{
\item{x}{annotationTable object}

\item{caption}{Character vector of length 1 or 2 containing the
    table's caption or title.  If length is 2, the second item is the
    "short caption" used when LaTeX generates a "List of Tables". Set to
    \code{NULL} to suppress the caption.  Default value is \code{NULL}. }

\item{label}{Character vector of length 1 containing the LaTeX label
    or HTML anchor. Set to \code{NULL} to suppress the label.  Default
    value is \code{NULL}. }

\item{align}{Character vector of length equal to the number of columns
    of the resulting table, indicating the alignment of the corresponding
    columns.  Also, \code{"|"} may be used to produce vertical lines
    between columns in LaTeX tables, but these are effectively ignored
    when considering the required length of the supplied vector.  If a
    character vector of length one is supplied, it is split as
    \code{strsplit(align, "")[[1]]} before processing. Since the row
    names are printed in the first column, the length of \code{align} is
    one greater than \code{ncol(x)} if \code{x} is a
    \code{data.frame}. Use \code{"l"}, \code{"r"}, and \code{"c"} to
    denote left, right, and center alignment, respectively.  Use
    \code{"p{3cm}"} etc. for a LaTeX column of the specified width. For
    HTML output the \code{"p"} alignment is interpreted as \code{"l"},
    ignoring the width request. Default depends on the class of
    \code{x}. }

\item{digits}{
    Numeric vector of length equal to one (in which case it will be
    replicated as necessary) or to the number of columns of the
    resulting table \bold{or} matrix of the same size as the resulting
    table, indicating the number of digits to display in the
    corresponding columns. Since the row names are printed in the first
    column, the length of the vector \code{digits} or the number of
    columns of the matrix \code{digits} is one greater than
    \code{ncol(x)} if \code{x} is a \code{data.frame}. Default depends
    on the class of \code{x}. If values of \code{digits} are negative, the
    corresponding values of \code{x} are displayed in scientific format
    with \code{abs(digits)} digits.}

\item{display}{
    Character vector of length equal to the number of columns of the
    resulting table, indicating the format for the corresponding columns.
    Since the row names are printed in the first column, the length of
    \code{display} is one greater than \code{ncol(x)} if \code{x} is a
    \code{data.frame}.  These values are passed to the \code{formatC}
    function.  Use \code{"d"} (for integers), \code{"f"}, \code{"e"},
    \code{"E"}, \code{"g"}, \code{"G"}, \code{"fg"} (for reals), or
    \code{"s"} (for strings).  \code{"f"} gives numbers in the usual
    \code{xxx.xxx} format; \code{"e"} and \code{"E"} give
    \code{n.ddde+nn} or \code{n.dddE+nn} (scientific format); \code{"g"}
    and \code{"G"} put \code{x[i]} into scientific format only if it
    saves space to do so.  \code{"fg"} uses fixed format as \code{"f"},
    but \code{digits} as number of \emph{significant} digits.  Note that
    this can lead to quite long result strings.  Default depends on the
    class of \code{x}.}

\item{...}{Additional arguments.  (Currently ignored.)}
}
\description{
\code{xtable} methods for several a4 objects, such as \code{annotationTable} objects, 
\code{topTable} objects etc.
}
\section{Methods}{

\describe{
\item{x = "annotationTable", caption = "missing", label = "missing", align = "missing", digits = "missing", display = "missing"}{generates a LaTeX representation for the given annotationTable}
\item{x = "annotationTable", caption = "ANY", label = "ANY", align = "ANY", digits = "ANY", display = "ANY"}{generates a LaTeX representation for the given annotationTable}
\item{x = "annotationTable", caption = "ANY", label = "ANY", align = "ANY", digits = "numeric", display = "ANY"}{generates a LaTeX representation for the given annotationTable}
}
}

\examples{
 ## some dummy data
  dData <- data.frame(someSymbol = LETTERS[1:5], accessionNumber = c("X83928", "V00540", "U21090", "L38487", "M34057"))
 at <- annotationTable(displayData = dData,  displayCols = list(accessionNumber = "EntrezId"))
 xat <- xtable(at)
 print(xat, include.rownames = FALSE)
}
\keyword{manip}
\keyword{methods}
