% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_functions.R
\name{transform_rownames_R_to_MATLAB}
\alias{transform_rownames_R_to_MATLAB}
\alias{transform_rownames_MATLAB_to_R}
\alias{transform_rownames_nature_to_R}
\alias{transform_rownames_YAPSA_to_deconstructSigs}
\alias{transform_rownames_deconstructSigs_to_YAPSA}
\title{Change rownames from one naming convention to another}
\usage{
transform_rownames_R_to_MATLAB(in_rownames, wordLength = 3)

transform_rownames_MATLAB_to_R(in_rownames, wordLength = 3)

transform_rownames_nature_to_R(in_rownames, wordLength = 3)

transform_rownames_YAPSA_to_deconstructSigs(in_rownames, wordLength = 3)

transform_rownames_deconstructSigs_to_YAPSA(in_rownames, wordLength = 3)
}
\arguments{
\item{in_rownames}{Character vector of input rownames}

\item{wordLength}{Size of the considered motif context}
}
\value{
A character vector of the translated rownames.
}
\description{
Rownames or names of the features used differ between the different contexts
a signature analysis is carried out in. The function
\code{transform_rownames_R_to_MATLAB} changes from the convention used in
the YAPSA pacakge to the one used by Alexandrov et al. in the MATLAB
framework.

The function \code{transform_rownames_MATLAB_to_R} changes from the 
convention used in Alexandrov et al. in the MATLAB framework to the one used
by the YAPSA pacakge.

The function \code{transform_rownames_MATLAB_to_R} changes from the 
convention used in stored mutational catalogues by Alexandrov et al. to the 
one used by the YAPSA pacakge.

The function \code{transform_rownames_YAPSA_to_deconstructSigs} changes from
the convention used in the YAPSA package to the one used by the 
deconstructSigs package.

The function \code{transform_rownames_YAPSA_to_deconstructSigs} changes from
the convention used in the deconstructSigs package to the one used by the 
YAPSA pacakge.
}
\examples{
NULL

}
